/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.FlushRegionCallable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionReplicaFlushHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RegionReplicaFlushHandler.class);
    private final ClusterConnection connection;
    private final RpcRetryingCallerFactory rpcRetryingCallerFactory;
    private final RpcControllerFactory rpcControllerFactory;
    private final int operationTimeout;
    private final HRegion region;

    public RegionReplicaFlushHandler(Server server, ClusterConnection connection, RpcRetryingCallerFactory rpcRetryingCallerFactory, RpcControllerFactory rpcControllerFactory, int operationTimeout, HRegion region) {
        super(server, EventType.RS_REGION_REPLICA_FLUSH);
        this.connection = connection;
        this.rpcRetryingCallerFactory = rpcRetryingCallerFactory;
        this.rpcControllerFactory = rpcControllerFactory;
        this.operationTimeout = operationTimeout;
        this.region = region;
    }

    @Override
    public void process() throws IOException {
        this.triggerFlushInPrimaryRegion(this.region);
    }

    @Override
    protected void handleException(Throwable t) {
        if (t instanceof InterruptedIOException || t instanceof InterruptedException) {
            LOG.error("Caught throwable while processing event " + (Object)((Object)this.eventType), t);
        } else if (t instanceof RuntimeException) {
            this.server.abort("ServerAborting because a runtime exception was thrown", t);
        } else {
            this.server.abort("ServerAborting because an exception was thrown", t);
        }
    }

    private int getRetriesCount(Configuration conf) {
        int numRetries = conf.getInt("hbase.client.retries.number", 15);
        if (numRetries > 10) {
            int mult = conf.getInt("hbase.client.serverside.retries.multiplier", 3);
            numRetries /= mult;
        }
        return numRetries;
    }

    void triggerFlushInPrimaryRegion(HRegion region) throws IOException, RuntimeException {
        long pause = this.connection.getConfiguration().getLong("hbase.client.pause", 100L);
        int maxAttempts = this.getRetriesCount(this.connection.getConfiguration());
        RetryCounter counter = new RetryCounterFactory(maxAttempts, (int)pause).create();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to do an RPC to the primary region replica " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getEncodedName() + " of region " + region.getRegionInfo().getEncodedName() + " to trigger a flush");
        }
        while (!(region.isClosing() || region.isClosed() || this.server.isAborted() || this.server.isStopped())) {
            FlushRegionCallable flushCallable = new FlushRegionCallable(this.connection, this.rpcControllerFactory, RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()), true);
            AdminProtos.FlushRegionResponse response = null;
            try {
                response = (AdminProtos.FlushRegionResponse)this.rpcRetryingCallerFactory.newCaller().callWithRetries((RetryingCallable)flushCallable, this.operationTimeout);
            }
            catch (IOException ex) {
                if (ex instanceof TableNotFoundException || this.connection.isTableDisabled(region.getRegionInfo().getTable())) {
                    return;
                }
                throw ex;
            }
            if (response.getFlushed()) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Successfully triggered a flush of primary region replica " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getEncodedName() + " of region " + region.getRegionInfo().getEncodedName() + " Now waiting and blocking reads until observing a full flush cycle");
                break;
            }
            if (response.hasWroteFlushWalMarker()) {
                if (response.getWroteFlushWalMarker()) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Successfully triggered an empty flush marker(memstore empty) of primary region replica " + ServerRegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)region.getRegionInfo()).getEncodedName() + " of region " + region.getRegionInfo().getEncodedName() + " Now waiting and " + "blocking reads until observing a flush marker");
                    break;
                }
                if (!counter.shouldRetry()) {
                    throw new IOException("Cannot cause primary to flush or drop a wal marker after retries. Failing opening of this region replica " + region.getRegionInfo().getEncodedName());
                }
            } else {
                LOG.warn("Was not able to trigger a flush from primary region due to old server version? Continuing to open the secondary region replica: " + region.getRegionInfo().getEncodedName());
                region.setReadsEnabled(true);
                break;
            }
            try {
                counter.sleepUntilNextRetry();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }
}

