/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.spark.client.SparkClientUtilities;
import org.apache.spark.Dependency;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.UnionRDD;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class SparkUtilities {
    public static HiveKey copyHiveKey(HiveKey key) {
        HiveKey copy = new HiveKey();
        copy.setDistKeyLength(key.getDistKeyLength());
        copy.setHashCode(key.hashCode());
        copy.set(key);
        return copy;
    }

    public static BytesWritable copyBytesWritable(BytesWritable bw) {
        BytesWritable copy = new BytesWritable();
        copy.set(bw);
        return copy;
    }

    public static URI uploadToHDFS(URI source, HiveConf conf) throws IOException {
        Path localFile = new Path(source.getPath());
        Path remoteFile = new Path(SessionState.get().getSparkSession().getHDFSSessionDir(), SparkUtilities.getFileName(source));
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        fileSystem.copyFromLocalFile(false, true, localFile, remoteFile);
        Path fullPath = fileSystem.getFileStatus(remoteFile).getPath();
        return fullPath.toUri();
    }

    public static boolean needUploadToHDFS(URI source, SparkConf sparkConf) {
        String master = sparkConf.get("spark.master");
        String deployMode = sparkConf.contains("spark.submit.deployMode") ? sparkConf.get("spark.submit.deployMode") : null;
        return SparkClientUtilities.isYarnClusterMode(master, deployMode) && !source.getScheme().equals("hdfs");
    }

    private static String getFileName(URI uri) {
        if (uri == null) {
            return null;
        }
        String name = FilenameUtils.getName((String)uri.getPath());
        return name;
    }

    public static boolean isDedicatedCluster(Configuration conf) {
        String master = conf.get("spark.master");
        return SparkClientUtilities.isYarnMaster(master) || SparkClientUtilities.isLocalMaster(master);
    }

    public static SparkSession getSparkSession(HiveConf conf, SparkSessionManager sparkSessionManager) throws HiveException {
        SparkSession sparkSession = SessionState.get().getSparkSession();
        HiveConf sessionConf = SessionState.get().getConf();
        if (sessionConf.getSparkConfigUpdated() || conf.getSparkConfigUpdated()) {
            sparkSessionManager.closeSession(sparkSession);
            sparkSession = null;
            conf.setSparkConfigUpdated(false);
            sessionConf.setSparkConfigUpdated(false);
        }
        sparkSession = sparkSessionManager.getSession(sparkSession, conf, true);
        SessionState.get().setSparkSession(sparkSession);
        return sparkSession;
    }

    public static String rddGraphToString(JavaPairRDD rdd) {
        StringBuilder sb = new StringBuilder();
        SparkUtilities.rddToString(rdd.rdd(), sb, "");
        return sb.toString();
    }

    private static void rddToString(RDD rdd, StringBuilder sb, String offset) {
        block4: {
            block3: {
                sb.append(offset).append(rdd.getClass().getCanonicalName()).append("[").append(rdd.hashCode()).append("]");
                if (rdd.getStorageLevel().useMemory()) {
                    sb.append("(cached)");
                }
                sb.append("\n");
                Collection dependencies = JavaConversions.asJavaCollection((Iterable)rdd.dependencies());
                if (dependencies == null) break block3;
                offset = offset + "\t";
                for (Dependency dependency : dependencies) {
                    RDD parentRdd = dependency.rdd();
                    SparkUtilities.rddToString(parentRdd, sb, offset);
                }
                break block4;
            }
            if (!(rdd instanceof UnionRDD)) break block4;
            UnionRDD unionRDD = (UnionRDD)rdd;
            offset = offset + "\t";
            Collection parentRdds = JavaConversions.asJavaCollection((Iterable)unionRDD.rdds());
            for (RDD parentRdd : parentRdds) {
                SparkUtilities.rddToString(parentRdd, sb, offset);
            }
        }
    }

    public static Path generateTmpPathForPartitionPruning(Path basePath, String id) {
        return new Path(basePath, id);
    }

    public static String getWorkId(BaseWork work) {
        String workName = work.getName();
        return workName.substring(workName.indexOf(" ") + 1);
    }

    public static SparkTask createSparkTask(HiveConf conf) {
        return (SparkTask)TaskFactory.get(new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID)), conf, new Task[0]);
    }

    public static SparkTask createSparkTask(SparkWork work, HiveConf conf) {
        return (SparkTask)TaskFactory.get(work, conf, new Task[0]);
    }

    public static void collectOp(Collection<Operator<?>> result, Operator<?> root, Class<?> clazz) {
        Preconditions.checkArgument(clazz != null, "AssertionError: clazz should not be null");
        if (root == null) {
            return;
        }
        if (clazz.equals(root.getClass())) {
            result.add(root);
        }
        for (Operator<OperatorDesc> child : root.getChildOperators()) {
            SparkUtilities.collectOp(result, child, clazz);
        }
    }
}

