/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IfExprStringScalarStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private byte[] arg2Scalar;
    private byte[] arg3Scalar;
    private int outputColumn;

    public IfExprStringScalarStringScalar(int arg1Column, byte[] arg2Scalar, byte[] arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Scalar = arg2Scalar;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprStringScalarStringScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        outputColVector.noNulls = true;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.initBuffer();
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                outputColVector.fill(this.arg2Scalar);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                        continue;
                    }
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (vector1[i] == 1L) {
                        outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                        continue;
                    }
                    outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    continue;
                }
                outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!arg1ColVector.isNull[i] && vector1[i] == 1L) {
                    outputColVector.setRef(i, this.arg2Scalar, 0, this.arg2Scalar.length);
                    continue;
                }
                outputColVector.setRef(i, this.arg3Scalar, 0, this.arg3Scalar.length);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "String";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", val " + IfExprStringScalarStringScalar.displayUtf8Bytes(this.arg2Scalar) + ", val " + IfExprStringScalarStringScalar.displayUtf8Bytes(this.arg3Scalar);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING, VectorExpressionDescriptor.ArgumentType.STRING).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

