/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hive.common.util.DateUtils;

@UDFType(deterministic=true)
public abstract class GenericUDF
implements Closeable {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};

    public abstract ObjectInspector initialize(ObjectInspector[] var1) throws UDFArgumentException;

    public void configure(MapredContext context) {
    }

    public ObjectInspector initializeAndFoldConstants(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector oi = this.initialize(arguments);
        if (this.getRequiredFiles() != null || this.getRequiredJars() != null) {
            return oi;
        }
        boolean allConstant = true;
        for (int ii = 0; ii < arguments.length; ++ii) {
            if (ObjectInspectorUtils.isConstantObjectInspector(arguments[ii])) continue;
            allConstant = false;
            break;
        }
        if (allConstant && !ObjectInspectorUtils.isConstantObjectInspector(oi) && FunctionRegistry.isDeterministic(this) && !FunctionRegistry.isStateful(this) && ObjectInspectorUtils.supportsConstantObjectInspector(oi)) {
            DeferredObject[] argumentValues = new DeferredJavaObject[arguments.length];
            for (int ii = 0; ii < arguments.length; ++ii) {
                argumentValues[ii] = new DeferredJavaObject(((ConstantObjectInspector)arguments[ii]).getWritableConstantValue());
            }
            try {
                Object constantValue = this.evaluate(argumentValues);
                oi = ObjectInspectorUtils.getConstantObjectInspector(oi, constantValue);
            }
            catch (HiveException e) {
                throw new UDFArgumentException(e);
            }
        }
        return oi;
    }

    public String[] getRequiredJars() {
        return null;
    }

    public String[] getRequiredFiles() {
        return null;
    }

    public abstract Object evaluate(DeferredObject[] var1) throws HiveException;

    public abstract String getDisplayString(String[] var1);

    @Override
    public void close() throws IOException {
    }

    public GenericUDF flip() {
        return this;
    }

    public GenericUDF negative() {
        throw new UnsupportedOperationException("Negative function doesn't exist for " + this.getFuncName());
    }

    public String getUdfName() {
        return this.getClass().getName();
    }

    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        if (this.getClass() != newInstance.getClass()) {
            throw new UDFArgumentException("Invalid copy between " + this.getClass().getName() + " and " + newInstance.getClass().getName());
        }
    }

    protected String getStandardDisplayString(String name, String[] children) {
        return this.getStandardDisplayString(name, children, ", ");
    }

    protected String getStandardDisplayString(String name, String[] children, String delim) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(delim);
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getFuncName() {
        return this.getClass().getSimpleName().substring(10).toLowerCase();
    }

    protected void checkArgsSize(ObjectInspector[] arguments, int min, int max) throws UDFArgumentLengthException {
        if (arguments.length < min || arguments.length > max) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getFuncName());
            sb.append(" requires ");
            if (min == max) {
                sb.append(min);
            } else {
                sb.append(min).append("..").append(max);
            }
            sb.append(" argument(s), got ");
            sb.append(arguments.length);
            throw new UDFArgumentLengthException(sb.toString());
        }
    }

    protected void checkArgPrimitive(ObjectInspector[] arguments, int i) throws UDFArgumentTypeException {
        ObjectInspector.Category oiCat = arguments[i].getCategory();
        if (oiCat != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes primitive types as " + this.getArgOrder(i) + " argument, got " + (Object)((Object)oiCat));
        }
    }

    protected void checkArgGroups(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping ... grps) throws UDFArgumentTypeException {
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        for (PrimitiveObjectInspectorUtils.PrimitiveGrouping grp : grps) {
            if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(inputType) != grp) continue;
            inputTypes[i] = inputType;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFuncName());
        sb.append(" only takes ");
        sb.append((Object)grps[0]);
        for (int j = 1; j < grps.length; ++j) {
            sb.append(", ");
            sb.append((Object)grps[j]);
        }
        sb.append(" types as ");
        sb.append(this.getArgOrder(i));
        sb.append(" argument, got ");
        sb.append((Object)inputType);
        throw new UDFArgumentTypeException(i, sb.toString());
    }

    protected void obtainStringConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        ObjectInspectorConverters.Converter converter;
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        converters[i] = converter = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        inputTypes[i] = inputType;
    }

    protected void obtainIntConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        ObjectInspectorConverters.Converter converter;
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        switch (inputType) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case VOID: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes INT/SHORT/BYTE types as " + this.getArgOrder(i) + " argument, got " + (Object)((Object)inputType));
            }
        }
        converters[i] = converter = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        inputTypes[i] = inputType;
    }

    protected void obtainLongConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        ObjectInspectorConverters.Converter converter;
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        switch (inputType) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes LONG/INT/SHORT/BYTE types as " + this.getArgOrder(i) + " argument, got " + (Object)((Object)inputType));
            }
        }
        converters[i] = converter = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        inputTypes[i] = inputType;
    }

    protected void obtainDoubleConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        ObjectInspectorConverters.Converter converter;
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        converters[i] = converter = ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        inputTypes[i] = inputType;
    }

    protected void obtainDateConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        AbstractPrimitiveWritableObjectInspector outOi;
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                outOi = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
                break;
            }
            case VOID: 
            case TIMESTAMP: 
            case DATE: {
                outOi = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
                break;
            }
            default: {
                throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes STRING_GROUP or DATE_GROUP types as " + this.getArgOrder(i) + " argument, got " + (Object)((Object)inputType));
            }
        }
        converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)inOi, (ObjectInspector)outOi);
        inputTypes[i] = inputType;
    }

    protected void obtainTimestampConverter(ObjectInspector[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws UDFArgumentTypeException {
        PrimitiveObjectInspector inOi = (PrimitiveObjectInspector)arguments[i];
        PrimitiveObjectInspector.PrimitiveCategory inputType = inOi.getPrimitiveCategory();
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case TIMESTAMP: 
            case DATE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes STRING_GROUP or DATE_GROUP types as " + this.getArgOrder(i) + " argument, got " + (Object)((Object)inputType));
            }
        }
        WritableTimestampObjectInspector outOi = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        converters[i] = ObjectInspectorConverters.getConverter((ObjectInspector)inOi, (ObjectInspector)outOi);
        inputTypes[i] = inputType;
    }

    protected String getStringValue(DeferredObject[] arguments, int i, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        return converters[i].convert(obj).toString();
    }

    protected Integer getIntValue(DeferredObject[] arguments, int i, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        Object writableValue = converters[i].convert(obj);
        int v = ((IntWritable)writableValue).get();
        return v;
    }

    protected Long getLongValue(DeferredObject[] arguments, int i, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        Object writableValue = converters[i].convert(obj);
        long v = ((LongWritable)writableValue).get();
        return v;
    }

    protected Double getDoubleValue(DeferredObject[] arguments, int i, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        Object writableValue = converters[i].convert(obj);
        double v = ((DoubleWritable)((Object)writableValue)).get();
        return v;
    }

    protected Date getDateValue(DeferredObject[] arguments, int i, PrimitiveObjectInspector.PrimitiveCategory[] inputTypes, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Date date;
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        switch (inputTypes[i]) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                String dateStr = converters[i].convert(obj).toString();
                try {
                    date = DateUtils.getDateFormat().parse(dateStr);
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: 
            case DATE: {
                Object writableValue = converters[i].convert(obj);
                date = ((DateWritable)writableValue).get();
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, this.getFuncName() + " only takes STRING_GROUP and DATE_GROUP types, got " + (Object)((Object)inputTypes[i]));
            }
        }
        return date;
    }

    protected Timestamp getTimestampValue(DeferredObject[] arguments, int i, ObjectInspectorConverters.Converter[] converters) throws HiveException {
        Object obj = arguments[i].get();
        if (obj == null) {
            return null;
        }
        Object writableValue = converters[i].convert(obj);
        if (writableValue == null) {
            return null;
        }
        Timestamp ts = ((TimestampWritable)writableValue).getTimestamp();
        return ts;
    }

    protected String getConstantStringValue(ObjectInspector[] arguments, int i) {
        Object constValue = ((ConstantObjectInspector)arguments[i]).getWritableConstantValue();
        String str = constValue == null ? null : constValue.toString();
        return str;
    }

    protected Boolean getConstantBooleanValue(ObjectInspector[] arguments, int i) throws UDFArgumentTypeException {
        Object constValue = ((ConstantObjectInspector)arguments[i]).getWritableConstantValue();
        if (constValue == null) {
            return false;
        }
        if (constValue instanceof BooleanWritable) {
            return ((BooleanWritable)constValue).get();
        }
        throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes BOOLEAN types as " + this.getArgOrder(i) + " argument, got " + constValue.getClass());
    }

    protected Integer getConstantIntValue(ObjectInspector[] arguments, int i) throws UDFArgumentTypeException {
        int v;
        Object constValue = ((ConstantObjectInspector)arguments[i]).getWritableConstantValue();
        if (constValue == null) {
            return null;
        }
        if (constValue instanceof IntWritable) {
            v = ((IntWritable)constValue).get();
        } else if (constValue instanceof ShortWritable) {
            v = ((ShortWritable)constValue).get();
        } else if (constValue instanceof ByteWritable) {
            v = ((ByteWritable)((Object)constValue)).get();
        } else {
            throw new UDFArgumentTypeException(i, this.getFuncName() + " only takes INT/SHORT/BYTE types as " + this.getArgOrder(i) + " argument, got " + constValue.getClass());
        }
        return v;
    }

    protected String getArgOrder(int i) {
        switch (++i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + ORDINAL_SUFFIXES[i % 10];
    }

    public static class DeferredJavaObject
    implements DeferredObject {
        private final Object value;

        public DeferredJavaObject(Object value) {
            this.value = value;
        }

        @Override
        public void prepare(int version) throws HiveException {
        }

        @Override
        public Object get() throws HiveException {
            return this.value;
        }
    }

    public static interface DeferredObject {
        public void prepare(int var1) throws HiveException;

        public Object get() throws HiveException;
    }
}

