/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.pmd;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.states.LengthLimitingTableModel;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;

public class PmdPreviewWorker
implements PreviewWorker {
    private PmdDataFactory dataFactory;
    private PreviewTableModel resultTableModel;
    private ReportDataFactoryException exception;
    private String query;
    private int queryTimeout;
    private int queryLimit;

    public PmdPreviewWorker(PmdDataFactory dataFactory, String query, int queryTimeout, int queryLimit) {
        this.queryTimeout = queryTimeout;
        this.queryLimit = queryLimit;
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        this.query = query;
        this.dataFactory = dataFactory;
    }

    public ReportDataFactoryException getException() {
        return this.exception;
    }

    public TableModel getResultTableModel() {
        return this.resultTableModel;
    }

    public void close() {
        if (this.resultTableModel != null) {
            this.resultTableModel.close();
            this.resultTableModel = null;
        }
        if (this.dataFactory != null) {
            this.dataFactory.close();
            this.dataFactory = null;
        }
    }

    public void cancelProcessing(CancelEvent event) {
        this.dataFactory.cancelRunningQuery();
    }

    public void run() {
        try {
            TableModel tableModel = this.dataFactory.queryData(this.query, (DataRow)new QueryDataRowWrapper((DataRow)new ParameterDataRow(), this.queryLimit, this.queryTimeout));
            this.resultTableModel = this.queryLimit > 0 ? new PreviewTableModel((MetaTableModel)new LengthLimitingTableModel(tableModel, this.queryLimit)) : new PreviewTableModel((MetaTableModel)tableModel);
        }
        catch (ReportDataFactoryException e) {
            this.exception = e;
        }
    }

    private static class PreviewTableModel
    implements CloseableTableModel,
    MetaTableModel {
        private MetaTableModel metaTableModel;
        private DefaultDataAttributeContext dataAttributeContext;

        private PreviewTableModel(MetaTableModel metaTableModel) {
            this.metaTableModel = metaTableModel;
            this.dataAttributeContext = new DefaultDataAttributeContext();
        }

        public void close() {
            if (this.metaTableModel instanceof CloseableTableModel) {
                CloseableTableModel ctm = (CloseableTableModel)this.metaTableModel;
                ctm.close();
            }
        }

        public DataAttributes getCellDataAttributes(int row, int column) {
            return this.metaTableModel.getCellDataAttributes(row, column);
        }

        public boolean isCellDataAttributesSupported() {
            return this.metaTableModel.isCellDataAttributesSupported();
        }

        public DataAttributes getColumnAttributes(int column) {
            return this.metaTableModel.getColumnAttributes(column);
        }

        public DataAttributes getTableAttributes() {
            return this.metaTableModel.getTableAttributes();
        }

        public int getRowCount() {
            return this.metaTableModel.getRowCount();
        }

        public int getColumnCount() {
            return this.metaTableModel.getColumnCount();
        }

        public String getColumnName(int columnIndex) {
            DataAttributes columnAttributes = this.getColumnAttributes(columnIndex);
            String friendlyName = (String)columnAttributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/pentaho-meta-data", "name", String.class, (DataAttributeContext)this.dataAttributeContext);
            if (friendlyName != null) {
                return friendlyName;
            }
            return this.metaTableModel.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.metaTableModel.getColumnClass(columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.metaTableModel.isCellEditable(rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.metaTableModel.getValueAt(rowIndex, columnIndex);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.metaTableModel.setValueAt(aValue, rowIndex, columnIndex);
        }

        public void addTableModelListener(TableModelListener l) {
            this.metaTableModel.addTableModelListener(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.metaTableModel.removeTableModelListener(l);
        }
    }
}

