/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.pmd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.SimplePmdDataFactory;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.ui.datasources.pmd.Messages;

public class SimplePmdDataSourceEditor
extends CommonDialog {
    private JTextField domainIdTextField;
    private JTextField filenameField;
    private DesignTimeContext context;

    public SimplePmdDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public SimplePmdDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public SimplePmdDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    private void init(DesignTimeContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.setModal(true);
        this.setTitle(Messages.getString("PmdDataSourceEditor.Title", new Object[0]));
        this.filenameField = new JTextField(null, 0);
        this.filenameField.setColumns(30);
        this.filenameField.getDocument().addDocumentListener(new FilenameDocumentListener());
        this.domainIdTextField = new JTextField(null, 0);
        this.domainIdTextField.setColumns(35);
        this.domainIdTextField.getDocument().addDocumentListener(new DomainTextFieldDocumentListener());
        super.init();
    }

    protected String getDialogId() {
        return "PmdDataSourceEditor.Simple";
    }

    protected Component createContentPane() {
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(this.filenameField);
        filePanel.add(new JButton(new BrowseAction()));
        JPanel queryConfigurationPanel = new JPanel();
        queryConfigurationPanel.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        queryConfigurationPanel.add(new JLabel(Messages.getString("PmdDataSourceEditor.XmiFileLabel", new Object[0])));
        queryConfigurationPanel.add(filePanel);
        queryConfigurationPanel.add(new JLabel(Messages.getString("PmdDataSourceEditor.DomainId", new Object[0])));
        queryConfigurationPanel.add(this.domainIdTextField);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)queryConfigurationPanel, "Center");
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return contentPanel;
    }

    public SimplePmdDataFactory performConfiguration(SimplePmdDataFactory dataFactory) {
        if (dataFactory != null) {
            this.filenameField.setText(dataFactory.getXmiFile());
            this.domainIdTextField.setText(dataFactory.getDomainId());
        }
        this.updateComponents();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        if (!this.performEdit()) {
            return null;
        }
        return this.createDataFactory();
    }

    private SimplePmdDataFactory createDataFactory() {
        SimplePmdDataFactory returnDataFactory = new SimplePmdDataFactory();
        returnDataFactory.setXmiFile(this.filenameField.getText());
        returnDataFactory.setDomainId(this.domainIdTextField.getText());
        returnDataFactory.setConnectionProvider((IPmdConnectionProvider)new PmdConnectionProvider());
        return returnDataFactory;
    }

    protected void updateComponents() {
        boolean isFileSelected = !StringUtils.isEmpty((String)this.filenameField.getText(), (boolean)true);
        this.domainIdTextField.setEnabled(isFileSelected);
    }

    private class FilenameDocumentListener
    implements DocumentListener {
        private FilenameDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SimplePmdDataSourceEditor.this.updateComponents();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SimplePmdDataSourceEditor.this.updateComponents();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SimplePmdDataSourceEditor.this.updateComponents();
        }
    }

    private class DomainTextFieldDocumentListener
    implements DocumentListener {
        private DomainTextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            SimplePmdDataSourceEditor.this.updateComponents();
        }
    }

    private class BrowseAction
    extends AbstractAction {
        protected BrowseAction() {
            this.putValue("Name", Messages.getString("PmdDataSourceEditor.Browse.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)SimplePmdDataSourceEditor.this.context.getReport());
            File initiallySelectedFile = !StringUtils.isEmpty((String)SimplePmdDataSourceEditor.this.filenameField.getText(), (boolean)true) ? (reportContextFile != null ? new File(reportContextFile.getParentFile(), SimplePmdDataSourceEditor.this.filenameField.getText()) : new File(SimplePmdDataSourceEditor.this.filenameField.getText())) : null;
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".xmi"}, Messages.getString("PmdDataSourceEditor.XmiFileName", new Object[0]) + " (*.xmi)", true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("xmifile");
            fileChooser.setSelectedFile(initiallySelectedFile);
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)SimplePmdDataSourceEditor.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            SimplePmdDataSourceEditor.this.filenameField.setText(path);
        }
    }
}

