/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.components.XulRadioGroup;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.util.Orient;

public class SwingRadioGroup
extends AbstractSwingContainer
implements XulRadioGroup {
    private ButtonGroup buttonGroup = new ButtonGroup();

    public SwingRadioGroup(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("radiogroup");
        this.orientation = Orient.VERTICAL;
        this.container = new JPanel(new GridBagLayout());
        this.setManagedObject(this.container);
        this.resetContainer();
    }

    @Override
    public void addChild(Element c) {
        this.addComponentToButtonGroup((XulComponent)c);
        super.addChild(c);
    }

    protected void addComponentToButtonGroup(XulComponent c) {
        for (XulComponent child : c.getChildNodes()) {
            this.addComponentToButtonGroup(child);
        }
        if (AbstractButton.class.isAssignableFrom(c.getManagedObject().getClass())) {
            this.buttonGroup.add((AbstractButton)c.getManagedObject());
        }
    }

    @Override
    public void resetContainer() {
        this.container.removeAll();
        this.gc = new GridBagConstraints();
        this.gc.gridy = -1;
        this.gc.gridx = 0;
        this.gc.gridheight = 1;
        this.gc.gridwidth = 0;
        this.gc.insets = new Insets(2, 2, 2, 2);
        this.gc.fill = 2;
        this.gc.anchor = 18;
        this.gc.weightx = 1.0;
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        this.resetContainer();
        super.replaceChild(oldElement, newElement);
    }
}

