/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulScale;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;
import org.pentaho.ui.xul.util.Orient;

public class SwingScale
extends SwingElement
implements XulScale {
    private int min = 0;
    private int max = 100;
    private int value = 0;
    private int increment = 1;
    private int pageIncrement = 1;
    private JSlider slider;
    private String direction;

    public SwingScale(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("scale");
    }

    public String getDir() {
        return this.direction;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getPageincrement() {
        return this.pageIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public void setDir(String direction) {
        this.direction = direction;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setPageincrement(int increment) {
        this.pageIncrement = increment;
    }

    public int getInc() {
        return this.increment;
    }

    public void setInc(int increment) {
        this.increment = increment;
    }

    public void setValue(int value) {
        int prevVal = this.value;
        this.value = value;
        if (this.slider != null) {
            this.slider.setValue(value);
        }
        this.changeSupport.firePropertyChange("value", prevVal, value);
    }

    @Override
    public void layout() {
        int orient = this.orientation == Orient.VERTICAL ? 1 : 0;
        this.slider = new JSlider(orient, this.min, this.max, Math.max(this.min, this.value));
        this.setManagedObject(this.slider);
        this.slider.setMajorTickSpacing(this.pageIncrement);
        this.slider.setSnapToTicks(false);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SwingScale.this.setValue(SwingScale.this.slider.getValue());
            }
        });
    }
}

