/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.di.ui.job.entries.google.bigquery;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.pentaho.di.job.entries.google.bigquery.JobEntryBigQueryLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntryBigQueryLoaderDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryBigQueryLoader.class;
    private static final String[] STRING_TRANS_FILTER_EXT = new String[]{"*.json;*.csv;*.avro", "*.*"};
    private JobEntryBigQueryLoader jobEntry;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Group gGoogeCloudStorage;
    private Label wlStorageSourceUrl;
    private FormData fdlStorageSourceUrl;
    private TextVar wStorageSourceUrl;
    private FormData fdStorageSourceUrl;
    private ComboVar wDatasetName;
    private Map<String, Dataset> datasets = new HashMap<String, Dataset>();
    private Label wlTableName;
    private ComboVar wTableName;
    private Map<String, Table> tables = new HashMap<String, Table>();
    private TextVar wLeadingRows;
    private TextVar wDelimiter;
    private TextVar wQuoteCharacter;
    private BigQuery bigQuery;
    private Composite wCsvOptions;
    private Label wlFileType;
    private ComboVar wFileType;
    private FormData fdlFileType;
    private FormData fdFileType;
    private TableView wFields;
    private Button wTruncateButton;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private boolean changed = false;
    private String[] fileTypes = new String[]{BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.TypeJSON.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.TypeCSV.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.TypeAvro.Label", (String[])new String[0])};
    private String[] STRING_FILTER_TEXT = new String[]{BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Option.SupportedFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Option.AllFiles", (String[])new String[0])};

    public JobEntryBigQueryLoaderDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryBigQueryLoader)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Name.Default", (String[])new String[0]));
        }
        this.bigQuery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = e -> this.jobEntry.setChanged();
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.EntryName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.top = new FormAttachment(0, 0);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.width = 250;
        this.fdName.left = new FormAttachment(0, 0);
        this.fdName.top = new FormAttachment((Control)this.wlName, 5);
        this.wName.setLayoutData((Object)this.fdName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wSetupTab = new CTabItem(wTabFolder, 0);
        wSetupTab.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Tab.Setup.Label", (String[])new String[0]));
        Composite wSetup = new Composite((Composite)wTabFolder, 32);
        this.props.setLook((Control)wSetup);
        FormLayout specLayout = new FormLayout();
        specLayout.marginWidth = 15;
        specLayout.marginHeight = 15;
        wSetup.setLayout((Layout)specLayout);
        this.gGoogeCloudStorage = new Group(wSetup, 16);
        this.gGoogeCloudStorage.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Group.GoogleCloudStorage", (String[])new String[0]));
        this.props.setLook((Control)this.gGoogeCloudStorage);
        FormLayout gGoogeCloudStorageLayout = new FormLayout();
        gGoogeCloudStorageLayout.marginWidth = 15;
        gGoogeCloudStorageLayout.marginHeight = 15;
        this.gGoogeCloudStorage.setLayout((Layout)gGoogeCloudStorageLayout);
        FormData fdgGoogeCloudStorage = new FormData();
        fdgGoogeCloudStorage.top = new FormAttachment(0, 0);
        fdgGoogeCloudStorage.left = new FormAttachment(0, 0);
        fdgGoogeCloudStorage.right = new FormAttachment(100, 0);
        this.gGoogeCloudStorage.setLayoutData((Object)fdgGoogeCloudStorage);
        this.wlStorageSourceUrl = new Label((Composite)this.gGoogeCloudStorage, 16384);
        this.wlStorageSourceUrl.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.StorageSourceUrl.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStorageSourceUrl);
        this.fdlStorageSourceUrl = new FormData();
        this.fdlStorageSourceUrl.left = new FormAttachment(0, 0);
        this.fdlStorageSourceUrl.top = new FormAttachment(0, 0);
        this.wlStorageSourceUrl.setLayoutData((Object)this.fdlStorageSourceUrl);
        Button wbBrowse = new Button((Composite)this.gGoogeCloudStorage, 8);
        wbBrowse.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Button.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, Const.isOSX() ? 5 : 0);
        fdBrowse.top = new FormAttachment((Control)this.wlStorageSourceUrl, Const.isOSX() ? 0 : 5);
        wbBrowse.setLayoutData((Object)fdBrowse);
        wbBrowse.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                JobEntryBigQueryLoaderDialog.this.selectVfsFile();
            }
        });
        this.wStorageSourceUrl = new TextVar((VariableSpace)this.jobMeta, (Composite)this.gGoogeCloudStorage, 18436);
        this.props.setLook((Control)this.wStorageSourceUrl);
        this.fdStorageSourceUrl = new FormData();
        this.fdStorageSourceUrl.left = new FormAttachment(0);
        this.fdStorageSourceUrl.top = new FormAttachment((Control)this.wlStorageSourceUrl, 5);
        this.fdStorageSourceUrl.right = new FormAttachment((Control)wbBrowse, -5);
        this.wStorageSourceUrl.setLayoutData((Object)this.fdStorageSourceUrl);
        Group gGoogleBigQuery = new Group(wSetup, 16);
        gGoogleBigQuery.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Group.GoogleBigQuery", (String[])new String[0]));
        this.props.setLook((Control)gGoogleBigQuery);
        FormLayout gGoogeBigQueryLayout = new FormLayout();
        gGoogeBigQueryLayout.marginWidth = 15;
        gGoogeBigQueryLayout.marginHeight = 15;
        gGoogleBigQuery.setLayout((Layout)gGoogeBigQueryLayout);
        FormData fdgGoogleBigQuery = new FormData();
        fdgGoogleBigQuery.top = new FormAttachment((Control)this.gGoogeCloudStorage, 15);
        fdgGoogleBigQuery.left = new FormAttachment(0, 0);
        fdgGoogleBigQuery.right = new FormAttachment(100, 0);
        fdgGoogleBigQuery.bottom = new FormAttachment(100, 0);
        gGoogleBigQuery.setLayoutData((Object)fdgGoogleBigQuery);
        Label wlDatasetName = new Label((Composite)gGoogleBigQuery, 16384);
        wlDatasetName.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Dataset.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDatasetName);
        FormData fdlDatasetName = new FormData();
        fdlDatasetName.left = new FormAttachment(0, 0);
        fdlDatasetName.top = new FormAttachment(0, 0);
        wlDatasetName.setLayoutData((Object)fdlDatasetName);
        this.wDatasetName = new ComboVar((VariableSpace)this.jobMeta, (Composite)gGoogleBigQuery, 2048);
        this.props.setLook((Control)this.wDatasetName);
        FormData fdDatasetName = new FormData();
        fdDatasetName.left = new FormAttachment(0);
        fdDatasetName.top = new FormAttachment((Control)wlDatasetName, 5);
        fdDatasetName.width = 220;
        this.wDatasetName.setLayoutData((Object)fdDatasetName);
        this.wDatasetName.addModifyListener(modifyEvent -> {
            this.updateTables(this.wDatasetName.getText());
            this.wTableName.setEnabled(!Utils.isEmpty((CharSequence)this.wDatasetName.getText()));
            this.wlTableName.setEnabled(!Utils.isEmpty((CharSequence)this.wDatasetName.getText()));
        });
        this.wlTableName = new Label((Composite)gGoogleBigQuery, 16384);
        this.wlTableName.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.TableName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTableName);
        FormData fdlTableName = new FormData();
        fdlTableName.left = new FormAttachment(0, 0);
        fdlTableName.top = new FormAttachment((Control)this.wDatasetName, 10);
        this.wlTableName.setLayoutData((Object)fdlTableName);
        Label wTable = new Label((Composite)gGoogleBigQuery, 16384);
        this.wTableName = new ComboVar((VariableSpace)this.jobMeta, (Composite)gGoogleBigQuery, 2048){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                JobEntryBigQueryLoaderDialog.this.setComponentBackground(enabled, (Control)this.getCComboWidget());
            }
        };
        this.props.setLook((Control)this.wTableName);
        FormData fdTableName = new FormData();
        fdTableName.left = new FormAttachment(0);
        fdTableName.top = new FormAttachment((Control)this.wlTableName, 5);
        fdTableName.width = 220;
        this.wTableName.setLayoutData((Object)fdTableName);
        this.wlTableName.setEnabled(false);
        this.wTableName.addModifyListener(modifyEvent -> {
            this.selectTable(this.wTableName.getText());
            this.wFields.setEnabled(!Utils.isEmpty((CharSequence)this.wTableName.getText()));
            wTable.setEnabled(!Utils.isEmpty((CharSequence)this.wTableName.getText()));
        });
        wTable.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Table.Label", (String[])new String[0]));
        wTable.setEnabled(false);
        this.props.setLook((Control)wTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0);
        fdlTable.top = new FormAttachment((Control)this.wTableName, 10);
        wTable.setLayoutData((Object)fdlTable);
        String[] types = new String[]{LegacySQLTypeName.BOOLEAN.toString(), LegacySQLTypeName.DATE.toString(), LegacySQLTypeName.DATETIME.toString(), LegacySQLTypeName.FLOAT.toString(), LegacySQLTypeName.INTEGER.toString(), LegacySQLTypeName.STRING.toString(), LegacySQLTypeName.TIME.toString(), LegacySQLTypeName.TIMESTAMP.toString()};
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Table.ColumnName.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Table.ColumnType.Label", (String[])new String[0]), 2, types)};
        this.wFields = new TableView((VariableSpace)this.jobMeta, (Composite)gGoogleBigQuery, 68114, colinf, 0, false, lsMod, this.props, false){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                JobEntryBigQueryLoaderDialog.this.setComponentBackground(enabled, (Control)this.getTable());
            }
        };
        this.wTruncateButton = new Button((Composite)gGoogleBigQuery, 32);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0);
        fdFields.top = new FormAttachment((Control)wTable, 5);
        fdFields.right = new FormAttachment(100);
        fdFields.bottom = new FormAttachment((Control)this.wTruncateButton, -5);
        fdFields.width = 220;
        this.props.setLook((Control)this.wFields);
        this.wFields.setLayoutData((Object)fdFields);
        this.wFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        this.wFields.setEnabled(false);
        this.wTruncateButton.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Truncate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTruncateButton);
        FormData fdTruncate = new FormData();
        fdTruncate.left = new FormAttachment(0);
        fdTruncate.bottom = new FormAttachment(100);
        fdTruncate.width = 220;
        this.wTruncateButton.setLayoutData((Object)fdTruncate);
        wSetupTab.setControl((Control)wSetup);
        FormData fdSetup = new FormData();
        fdSetup.top = new FormAttachment(0);
        fdSetup.right = new FormAttachment(100);
        fdSetup.bottom = new FormAttachment(100);
        fdSetup.left = new FormAttachment(0);
        wSetup.setLayoutData((Object)fdSetup);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Tab.File.Label", (String[])new String[0]));
        Composite wFile = new Composite((Composite)wTabFolder, 32);
        this.props.setLook((Control)wFile);
        wFile.setLayout((Layout)specLayout);
        this.wlFileType = new Label(wFile, 16384);
        this.wlFileType.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.FileType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFileType);
        this.fdlFileType = new FormData();
        this.fdlFileType.left = new FormAttachment(0, 0);
        this.fdlFileType.top = new FormAttachment(0, 0);
        this.wlFileType.setLayoutData((Object)this.fdlFileType);
        this.wFileType = new ComboVar((VariableSpace)this.jobMeta, wFile, 2060);
        this.wFileType.setItems(this.fileTypes);
        this.wFileType.select(0);
        this.wFileType.addModifyListener(modifyEvent -> this.wCsvOptions.setVisible(this.jobMeta.environmentSubstitute(this.wFileType.getText()).equals(this.fileTypes[1])));
        this.props.setLook((Control)this.wFileType);
        this.fdFileType = new FormData();
        this.fdFileType.left = new FormAttachment(0);
        this.fdFileType.top = new FormAttachment((Control)this.wlFileType, 10);
        this.fdFileType.width = 125;
        this.wFileType.setLayoutData((Object)this.fdFileType);
        this.wCsvOptions = new Composite(wFile, 0);
        this.props.setLook((Control)this.wCsvOptions);
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginWidth = 0;
        optionsLayout.marginHeight = 0;
        this.wCsvOptions.setLayout((Layout)optionsLayout);
        Label wlLeadingRows = new Label(this.wCsvOptions, 16384);
        wlLeadingRows.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.LeadingRows.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLeadingRows);
        FormData fdlLeadingRows = new FormData();
        fdlLeadingRows.left = new FormAttachment(0);
        fdlLeadingRows.top = new FormAttachment(0);
        wlLeadingRows.setLayoutData((Object)fdlLeadingRows);
        this.wLeadingRows = new TextVar((VariableSpace)this.jobMeta, this.wCsvOptions, 2048);
        this.props.setLook((Control)wlLeadingRows);
        FormData fdLeadingRows = new FormData();
        fdLeadingRows.left = new FormAttachment(0);
        fdLeadingRows.top = new FormAttachment((Control)wlLeadingRows, 5);
        fdLeadingRows.width = 125;
        this.wLeadingRows.setLayoutData((Object)fdLeadingRows);
        Label wlDelimiter = new Label(this.wCsvOptions, 16384);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment(0);
        fdlDelimiter.top = new FormAttachment((Control)this.wLeadingRows, 5);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.jobMeta, this.wCsvOptions, 2048);
        this.props.setLook((Control)this.wDelimiter);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment(0);
        fdDelimiter.top = new FormAttachment((Control)wlDelimiter, 5);
        fdDelimiter.width = 125;
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        Label wlQuoteCharacter = new Label(this.wCsvOptions, 16384);
        wlQuoteCharacter.setText(BaseMessages.getString(PKG, (String)"GoogleBigQueryStorageLoad.QuoteCharacter.Label", (String[])new String[0]));
        this.props.setLook((Control)wlQuoteCharacter);
        FormData fdlQuoteCharacter = new FormData();
        fdlQuoteCharacter.left = new FormAttachment(0);
        fdlQuoteCharacter.top = new FormAttachment((Control)this.wDelimiter, 5);
        wlQuoteCharacter.setLayoutData((Object)fdlQuoteCharacter);
        this.wQuoteCharacter = new TextVar((VariableSpace)this.jobMeta, this.wCsvOptions, 2048);
        this.props.setLook((Control)this.wQuoteCharacter);
        FormData fdQuoteCharacter = new FormData();
        fdQuoteCharacter.left = new FormAttachment(0);
        fdQuoteCharacter.top = new FormAttachment((Control)wlQuoteCharacter, 5);
        fdQuoteCharacter.width = 125;
        this.wQuoteCharacter.setLayoutData((Object)fdQuoteCharacter);
        FormData fdCsvOptions = new FormData();
        fdCsvOptions.top = new FormAttachment((Control)this.wFileType, 10);
        fdCsvOptions.left = new FormAttachment(0);
        this.wCsvOptions.setLayoutData((Object)fdCsvOptions);
        wFileTab.setControl((Control)wFile);
        FormData fdFile = new FormData();
        fdFile.top = new FormAttachment(0);
        fdFile.right = new FormAttachment(100);
        fdFile.bottom = new FormAttachment(100);
        fdFile.left = new FormAttachment(0);
        wFile.setLayoutData((Object)fdFile);
        wTabFolder.setSelection(0);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)spacer, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsCancel = e -> this.cancel();
        this.lsOK = e -> this.ok();
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryBigQueryLoaderDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell, (int)530, (int)650);
        this.shell.setMinimumSize(530, 650);
        this.shell.open();
        this.props.setDialogSize(this.shell, "GoogleBigQueryStorageLoadDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"google-bigquery.svg", (int)48, (int)48);
    }

    protected void setComponentBackground(Boolean enabled, Control control) {
        if (Display.getDefault() != null) {
            Color foreground = Display.getDefault().getSystemColor(enabled != false ? 2 : 16);
            Color background = Display.getDefault().getSystemColor(enabled != false ? 1 : 22);
            control.setBackground(background);
            control.setForeground(foreground);
        }
    }

    private void selectVfsFile() {
        String currentFile = this.jobMeta.environmentSubstitute(this.wStorageSourceUrl.getText());
        FileObject root = null;
        FileObject parent = null;
        try {
            root = KettleVFS.getFileObject((String)currentFile);
            if (root != null) {
                parent = root.getParent();
            }
        }
        catch (FileSystemException | KettleFileException throwable) {
            // empty catch block
        }
        VfsFileChooserDialog vfsFileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(parent, root);
        FileObject fileObject = vfsFileChooserDialog.open(this.shell, null, STRING_TRANS_FILTER_EXT, this.STRING_FILTER_TEXT, 0);
        if (fileObject != null) {
            String filename = fileObject.getName().toString();
            this.wStorageSourceUrl.setText(filename);
        }
    }

    private void updateTables(String datasetName) {
        this.wTableName.removeAll();
        this.wFields.removeAll();
        Dataset dataset = this.datasets.get(this.jobMeta.environmentSubstitute(datasetName));
        if (dataset != null) {
            Page tablePage = this.bigQuery.listTables(dataset.getDatasetId(), new BigQuery.TableListOption[0]);
            for (Table table : tablePage.iterateAll()) {
                String name = !Utils.isEmpty((CharSequence)table.getFriendlyName()) ? table.getFriendlyName() : table.getTableId().getTable();
                this.tables.put(name, table);
            }
            this.wTableName.setItems((String[])Arrays.copyOf(this.tables.keySet().toArray(), this.tables.size(), String[].class));
        }
    }

    private void selectTable(String tableName) {
        Table fullTable;
        Schema schema;
        Table table = this.tables.get(this.jobMeta.environmentSubstitute(tableName));
        this.wFields.table.removeAll();
        if (table != null && (schema = (fullTable = this.bigQuery.getTable(table.getTableId(), new BigQuery.TableOption[0])).getDefinition().getSchema()) != null) {
            for (Field field : schema.getFields()) {
                TableItem tableItem = new TableItem(this.wFields.table, 0);
                tableItem.setText(1, field.getName());
                tableItem.setText(2, field.getType().toString());
            }
        }
    }

    public void getData() {
        Page datasetPage = this.bigQuery.listDatasets(new BigQuery.DatasetListOption[0]);
        for (Dataset dataset : datasetPage.iterateAll()) {
            String name = !Utils.isEmpty((CharSequence)dataset.getFriendlyName()) ? dataset.getFriendlyName() : dataset.getDatasetId().getDataset();
            this.datasets.put(name, dataset);
        }
        this.wDatasetName.setItems((String[])Arrays.copyOf(this.datasets.keySet().toArray(), this.datasets.size(), String[].class));
        this.wName.setText(this.jobEntry.getName());
        this.wStorageSourceUrl.setText(Const.nullToEmpty((String)this.jobEntry.getSourceUri()));
        this.wDatasetName.setText(Const.nullToEmpty((String)this.jobEntry.getDatasetName()));
        this.wTableName.setText(Const.nullToEmpty((String)this.jobEntry.getTableName()));
        this.wTableName.setEnabled(!Utils.isEmpty((CharSequence)this.wDatasetName.getText()));
        this.wFields.setEnabled(!Utils.isEmpty((CharSequence)this.wTableName.getText()));
        this.wFileType.setText(Const.nullToEmpty((String)this.jobEntry.getFileType()));
        this.wDelimiter.setText(Const.nullToEmpty((String)this.jobEntry.getDelimiter()));
        this.wLeadingRows.setText("" + this.jobEntry.getLeadingRowsToSkip());
        this.wQuoteCharacter.setText(Const.nullToEmpty((String)this.jobEntry.getQuote()));
        this.wCsvOptions.setVisible(this.jobMeta.environmentSubstitute(this.wFileType.getText()).equals(this.fileTypes[1]));
        this.wTruncateButton.setSelection(this.jobEntry.isTruncateTable());
        this.wFields.table.removeAll();
        for (int i = 0; i < this.jobEntry.getFieldNames().length; ++i) {
            TableItem ti = new TableItem(this.wFields.table, 0);
            ti.setText(0, "" + (i + 1));
            if (this.jobEntry.getFieldNames()[i] != null) {
                ti.setText(1, this.jobEntry.getFieldNames()[i]);
            }
            if (this.jobEntry.getFieldTypes()[i] == null) continue;
            ti.setText(2, this.jobEntry.getFieldTypes()[i]);
        }
        if (this.wFields.table.getItemCount() == 0) {
            TableItem ti = new TableItem(this.wFields.table, 0);
            ti.setText(0, "001");
        }
    }

    private void ok() {
        if (null == this.wName.getText() || this.wName.getText().length() == 0) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setDelimiter(this.wDelimiter.getText());
        this.jobEntry.setDatasetName(this.wDatasetName.getText());
        this.jobEntry.setTableName(this.wTableName.getText());
        this.jobEntry.setLeadingRowsToSkip(this.wLeadingRows.getText());
        this.jobEntry.setSourceUri(this.wStorageSourceUrl.getText());
        this.jobEntry.setFileType(this.wFileType.getText());
        this.jobEntry.setQuote(this.wQuoteCharacter.getText());
        this.jobEntry.setTruncateTable(this.wTruncateButton.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        this.jobEntry.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.jobEntry.getFieldNames()[i] = item.getText(1);
            this.jobEntry.getFieldTypes()[i] = item.getText(2);
        }
        this.dispose();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }
}

