/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ResourceStatistics
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private Long numRecords;
    private Long avgRecordSize;
    private ResourceFieldStatistics[] fields = new ResourceFieldStatistics[0];
    private Long bytes;

    public Long getmBytes() {
        return this.bytes / 1024L / 1024L;
    }

    @Deprecated
    public ResourceStatistics setmBytes(Long mBytes) {
        this.bytes = mBytes * 1024L * 1024L;
        return this;
    }

    public void setSizeInBytes(Long bytes) {
        this.bytes = bytes;
    }

    public Long getSizeInBytes() {
        return this.bytes;
    }

    public Long getNumRecords() {
        return this.numRecords;
    }

    public ResourceStatistics setNumRecords(Long numRecords) {
        this.numRecords = numRecords;
        return this;
    }

    public Long getAvgRecordSize() {
        if (this.avgRecordSize == null && this.bytes != null && this.numRecords != null) {
            return this.bytes / this.numRecords;
        }
        return this.avgRecordSize;
    }

    public void setAvgRecordSize(Long sizeInBytes) {
        this.avgRecordSize = sizeInBytes;
    }

    public ResourceFieldStatistics[] getFields() {
        return this.fields;
    }

    public ResourceStatistics setFields(ResourceFieldStatistics[] fields) {
        if (fields != null) {
            this.fields = Arrays.copyOf(fields, fields.length);
        }
        return this;
    }

    public boolean equals(Object anOther) {
        if (anOther == null || !anOther.getClass().equals(this.getClass())) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics)anOther;
        return Arrays.equals(this.fields, other.fields) && (this.bytes == null ? other.bytes == null : this.bytes.equals(other.bytes)) && (this.numRecords == null ? other.numRecords == null : this.numRecords.equals(other.numRecords));
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + Arrays.hashCode(this.fields);
        hash = 31 * hash + (this.bytes == null ? 0 : this.bytes.hashCode());
        hash = 31 * hash + (this.numRecords == null ? 0 : this.numRecords.hashCode());
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Field Stats: \n");
        for (ResourceFieldStatistics f : this.fields) {
            sb.append(f.toString());
        }
        sb.append("bytes: " + this.bytes);
        sb.append("numRecords: " + this.numRecords);
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class ResourceFieldStatistics
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int version;
        private Long numDistinctValues;
        private Object[] mostCommonValues = new Object[0];
        private float[] mostCommonValuesFreq = new float[0];
        private Object[] valueHistogram = new Object[0];

        public int getVersion() {
            return this.version;
        }

        public ResourceFieldStatistics setVersion(int version) {
            this.version = version;
            return this;
        }

        public Long getNumDistinctValues() {
            return this.numDistinctValues;
        }

        public ResourceFieldStatistics setNumDistinctValues(Long numDistinctValues) {
            this.numDistinctValues = numDistinctValues;
            return this;
        }

        public Object[] getMostCommonValues() {
            return this.mostCommonValues;
        }

        public ResourceFieldStatistics setMostCommonValues(Object[] mostCommonValues) {
            if (mostCommonValues != null) {
                this.mostCommonValues = Arrays.copyOf(mostCommonValues, mostCommonValues.length);
            }
            return this;
        }

        public float[] getMostCommonValuesFreq() {
            return this.mostCommonValuesFreq;
        }

        public ResourceFieldStatistics setMostCommonValuesFreq(float[] mostCommonValuesFreq) {
            if (mostCommonValuesFreq != null) {
                this.mostCommonValuesFreq = Arrays.copyOf(mostCommonValuesFreq, mostCommonValuesFreq.length);
            }
            return this;
        }

        public Object[] getValueHistogram() {
            return this.valueHistogram;
        }

        public ResourceFieldStatistics setValueHistogram(Object[] valueHistogram) {
            if (valueHistogram != null) {
                this.valueHistogram = Arrays.copyOf(valueHistogram, valueHistogram.length);
            }
            return this;
        }

        public boolean equals(Object anOther) {
            if (anOther == null || !anOther.getClass().equals(this.getClass())) {
                return false;
            }
            ResourceFieldStatistics other = (ResourceFieldStatistics)anOther;
            return Arrays.equals(this.mostCommonValues, other.mostCommonValues) && Arrays.equals(this.mostCommonValuesFreq, other.mostCommonValuesFreq) && Arrays.equals(this.valueHistogram, other.valueHistogram) && this.numDistinctValues.equals(other.numDistinctValues) && this.version == other.version;
        }

        public int hashCode() {
            int hash = 1;
            hash = 31 * hash + Arrays.hashCode(this.mostCommonValues);
            hash = 31 * hash + Arrays.hashCode(this.mostCommonValuesFreq);
            hash = 31 * hash + this.numDistinctValues.hashCode();
            hash = 31 * hash + Arrays.hashCode(this.valueHistogram);
            hash = 31 * hash + this.version;
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ResourceStatistics. Version: " + this.version + "\n");
            sb.append("MCV:\n");
            for (Object o : this.mostCommonValues) {
                sb.append('[' + o.toString() + ']');
            }
            sb.append("\n MCVfreq:\n");
            float[] fArray = this.mostCommonValuesFreq;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float f = Float.valueOf(fArray[i]);
                sb.append('[' + f.toString() + ']');
            }
            sb.append("\n");
            sb.append("numDistVals: " + this.numDistinctValues);
            sb.append("valHistogram: \n");
            for (Object o : this.valueHistogram) {
                sb.append('[' + o.toString() + ']');
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

