/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.util.HashSet;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.UdfCacheShipFilesVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class SparkPOUserFuncVisitor
extends SparkOpPlanVisitor {
    private Set<String> cacheFiles = new HashSet<String>();
    private Set<String> shipFiles = new HashSet<String>();

    public SparkPOUserFuncVisitor(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOperator) throws VisitorException {
        if (!sparkOperator.physicalPlan.isEmpty()) {
            UdfCacheShipFilesVisitor udfCacheFileVisitor = new UdfCacheShipFilesVisitor(sparkOperator.physicalPlan);
            udfCacheFileVisitor.visit();
            this.cacheFiles.addAll(udfCacheFileVisitor.getCacheFiles());
            this.shipFiles.addAll(udfCacheFileVisitor.getShipFiles());
        }
    }

    public Set<String> getCacheFiles() {
        return this.cacheFiles;
    }

    public Set<String> getShipFiles() {
        return this.shipFiles;
    }
}

