/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;

public class UDFJarsFinder
extends SparkOpPlanVisitor {
    private PigContext pigContext = null;
    private Set<String> udfJars = new HashSet<String>();

    public UDFJarsFinder(SparkOperPlan plan, PigContext pigContext) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DependencyOrderWalker<SparkOperator, SparkOperPlan>(plan));
        this.pigContext = pigContext;
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        for (String udf : sparkOp.UDFs) {
            try {
                String jar;
                Class clazz = this.pigContext.getClassForAlias(udf);
                if (clazz == null || (jar = JarManager.findContainingJar(clazz)) == null) continue;
                this.udfJars.add(jar);
            }
            catch (IOException e) {
                throw new VisitorException(e);
            }
        }
    }

    public Set<String> getUdfJars() {
        return this.udfJars;
    }
}

