/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigWarning;
import org.apache.pig.tools.pigstats.PigWarnCounter;
import org.apache.pig.tools.pigstats.spark.SparkCounter;
import org.apache.pig.tools.pigstats.spark.SparkCounterGroup;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkCounters
implements Serializable,
PigWarnCounter {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(SparkCounters.class);
    private Map<String, SparkCounterGroup> sparkCounterGroups;
    private final transient JavaSparkContext javaSparkContext;

    private SparkCounters() {
        this(null);
    }

    public SparkCounters(JavaSparkContext javaSparkContext) {
        this.javaSparkContext = javaSparkContext;
        this.sparkCounterGroups = new HashMap<String, SparkCounterGroup>();
    }

    public void createCounter(Enum<?> key) {
        this.createCounter(key.getDeclaringClass().getName(), key.name());
    }

    public void createCounter(String groupName, Enum<?> key) {
        this.createCounter(groupName, key.name(), 0L);
    }

    public void createCounter(String groupName, String counterName) {
        this.createCounter(groupName, counterName, 0L);
    }

    public void createCounter(String groupName, String counterName, Object initValue) {
        this.getGroup(groupName).createCounter(counterName, initValue);
    }

    public void increment(Enum<?> key, long incrValue) {
        this.increment(key.getDeclaringClass().getName(), key.name(), incrValue);
    }

    public void increment(String groupName, String counterName, long value) {
        SparkCounter counter = this.getGroup(groupName).getCounter(counterName);
        if (counter == null) {
            LOG.error((Object)String.format("counter[%s, %s] has not initialized before.", groupName, counterName));
        } else {
            counter.increment(value);
        }
    }

    public Object getValue(String groupName, String counterName) {
        SparkCounter counter = this.getGroup(groupName).getCounter(counterName);
        if (counter == null) {
            LOG.error((Object)String.format("counter[%s, %s] has not initialized before.", groupName, counterName));
            return null;
        }
        return counter.getValue();
    }

    public SparkCounter getCounter(String groupName, String counterName) {
        return this.getGroup(groupName).getCounter(counterName);
    }

    public SparkCounter getCounter(Enum<?> key) {
        return this.getCounter(key.getDeclaringClass().getName(), key.name());
    }

    private SparkCounterGroup getGroup(String groupName) {
        SparkCounterGroup group = this.sparkCounterGroups.get(groupName);
        if (group == null) {
            group = new SparkCounterGroup.LongSparkCounterGroup(groupName, groupName, this.javaSparkContext);
            this.sparkCounterGroups.put(groupName, group);
        }
        return group;
    }

    public Map<String, SparkCounterGroup> getSparkCounterGroups() {
        return this.sparkCounterGroups;
    }

    @Override
    public boolean incrWarnCounter(Enum<?> name, Object incr) {
        SparkCounter counter = this.getCounter(PigWarning.SPARK_WARN);
        return SparkCounters._incrWarnCounter(counter, name.name(), (Long)incr);
    }

    @Override
    public boolean incrWarnCounter(String group, String name, Object incr) {
        SparkCounter counter = this.getCounter(PigWarning.SPARK_CUSTOM_WARN);
        return SparkCounters._incrWarnCounter(counter, group + "::" + name, (Long)incr);
    }

    private static boolean _incrWarnCounter(SparkCounter counter, String name, Long incr) {
        if (counter == null) {
            return false;
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(name, incr);
        counter.increment(map);
        return true;
    }
}

