/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class InformixDatabaseDialect
extends AbstractDatabaseDialect {
    private static final long serialVersionUID = -3869260264366995990L;
    private static final IDatabaseType DBTYPE = new DatabaseType("Informix", "INFORMIX", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.ODBC, DatabaseAccessType.JNDI), 9088, "http://publib.boulder.ibm.com/infocenter/idshelp/v10/index.jsp?topic=/com.ibm.jdbc_pg.doc/jdbc212.htm");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        if (connection.getAccessType() == DatabaseAccessType.ODBC) {
            return "jdbc:odbc:" + connection.getDatabaseName();
        }
        return "jdbc:informix-sqli://" + connection.getHostname() + ":" + connection.getDatabasePort() + "/" + connection.getDatabaseName() + ":INFORMIXSERVER=" + connection.getInformixServername() + ";DELIMIDENT=Y";
    }

    @Override
    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME YEAR to FRACTION";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "SERIAL8";
                        break;
                    }
                    retval = retval + "INTEGER PRIMARY KEY";
                    break;
                }
                if (length < 0 && precision < 0 || precision > 0 || length > 9) {
                    retval = retval + "FLOAT";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                if (length < 256) {
                    retval = retval + "VARCHAR";
                    if (length <= 0) break;
                    retval = retval + "(" + length + ")";
                    break;
                }
                if (length < 32768) {
                    retval = retval + "LVARCHAR";
                    break;
                }
                retval = retval + "TEXT";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + " ";
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"ifxjdbc.jar"};
    }

    @Override
    public String getNativeDriver() {
        return "com.informix.jdbc.IfxDriver";
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:informix-sqli:";
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public boolean needsPlaceHolder() {
        return true;
    }

    @Override
    public boolean needsToLockAllTables() {
        return false;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT FIRST 1 * FROM " + tableName;
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT FIRST 1 " + columnname + " FROM " + tableName;
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        String sql = "";
        for (int i = 0; i < tableNames.length; ++i) {
            sql = sql + "LOCK TABLE " + tableNames[i] + " IN EXCLUSIVE MODE;" + " ";
        }
        return sql;
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }
}

