/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.googlecloudstorage.ui;

import com.pentaho.googlecloudstorage.vfs.GoogleCloudStorageFileProvider;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class GoogleCloudStorageFileChooserDialog
extends CustomVfsUiPanel {
    private static Class<?> PKG = GoogleCloudStorageFileChooserDialog.class;
    private LogChannel log = new LogChannel((Object)this);
    private FileObject rootFile;
    private FileObject initialFile;
    private VfsFileChooserDialog vfsFileChooserDialog;

    public GoogleCloudStorageFileChooserDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super(GoogleCloudStorageFileProvider.SCHEME, GoogleCloudStorageFileProvider.SCHEME_NAME, vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.setLayout((Layout)new GridLayout());
    }

    public void activate() {
        this.vfsFileChooserDialog.setRootFile(this.rootFile);
        this.vfsFileChooserDialog.setInitialFile(this.initialFile);
        this.vfsFileChooserDialog.openFileCombo.setText("gs://");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
        try {
            FileObject newRoot = this.resolveFile(this.vfsFileChooserDialog.openFileCombo.getText());
            this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private FileSystemOptions getFileSystemOptions() throws FileSystemException {
        return new FileSystemOptions();
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

