/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.googlecloudstorage.vfs;

import com.pentaho.googlecloudstorage.vfs.GoogleCloudStorageFileSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileNameParser;

public class GoogleCloudStorageFileProvider
extends AbstractOriginatingFileProvider {
    public static String SCHEME = "gs";
    public static String SCHEME_NAME = "Google Cloud Storage";
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.RANDOM_ACCESS_READ));

    public GoogleCloudStorageFileProvider() {
        this.setFileNameParser((FileNameParser)new URLFileNameParser(80));
    }

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new GoogleCloudStorageFileSystem(fileName, fileSystemOptions);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

