/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.service.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.commons.metadata.mqleditor.Operator;
import org.pentaho.commons.metadata.mqleditor.beans.Condition;

public class FormulaParser {
    private static final String WRAPPED = "([^\\(]*)\\(\\[([^\\]]*)\\];(.*)(?=\\))";
    private static final String GENERIC = "\\[([^\\]]*)\\]\\s*([><=]+)\\s*(.*)";
    private static final String DATEVALUE = "DATEVALUE\\(([^\\)]*)";
    private static final String VALUE_EVAL = ".*\"(.*)\"";
    private static final String VALUE_EVAL_IN = "[^\"]*\"([^\"]*)\";{0,1}";
    private static final String VALUE_EVAL_IN_NUMERIC = "\\s*([^;\\s]+)\\s*;{0,1}";
    private static Pattern genericPat = Pattern.compile("\\[([^\\]]*)\\]\\s*([><=]+)\\s*(.*)");
    private static Pattern wrappedPat = Pattern.compile("([^\\(]*)\\(\\[([^\\]]*)\\];(.*)(?=\\))");
    private static Pattern valueEvalPat = Pattern.compile(".*\"(.*)\"");
    private static Pattern valueEvalInPat = Pattern.compile("[^\"]*\"([^\"]*)\";{0,1}");
    private static Pattern valueEvalInNumericPat = Pattern.compile("\\s*([^;\\s]+)\\s*;{0,1}");
    private static Pattern datevaluePat = Pattern.compile("DATEVALUE\\(([^\\)]*)");
    private String functionName = null;
    private String fieldName = null;
    private String value = null;
    private String catId = null;
    private String colId = null;
    private String aggType = null;
    private boolean notOperator = false;
    private String formula;
    private Condition c = new Condition();
    private String[] valueArray;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public FormulaParser(String formula) {
        this.formula = formula;
        this.parse();
    }

    private String checkValueAsDataTime(String value) {
        Matcher m = datevaluePat.matcher(value);
        if (m.find()) {
            return m.group(1);
        }
        return value;
    }

    private void parse() {
        Matcher m = genericPat.matcher(this.formula);
        if (m.find()) {
            this.functionName = m.group(2);
            this.fieldName = m.group(1);
            this.value = m.group(3);
            this.value = this.checkValueAsDataTime(this.value);
        } else {
            if (this.formula.contains("NOT(")) {
                this.notOperator = true;
                this.formula = this.formula.substring(4, this.formula.length() - 1);
            }
            if (this.formula.contains("ISNA(")) {
                this.formula = this.formula.substring(5, this.formula.length() - 1);
                this.fieldName = this.formula.substring(1, this.formula.length() - 1);
                this.functionName = "ISNA";
                this.value = "";
            }
            if ((m = wrappedPat.matcher(this.formula)).find()) {
                this.functionName = m.group(1);
                this.fieldName = m.group(2);
                this.value = m.group(3);
                this.value = this.checkValueAsDataTime(this.value);
            }
        }
        Operator op = Operator.parse(this.functionName.toUpperCase());
        if (this.notOperator) {
            switch (op) {
                case IS_NULL: {
                    op = Operator.IS_NOT_NULL;
                    break;
                }
                case CONTAINS: {
                    op = Operator.DOES_NOT_CONTAIN;
                }
            }
        }
        this.c.setOperator(op);
        if (this.value != null) {
            Matcher matcher;
            if (this.c.getOperator() == Operator.IN) {
                matcher = null;
                matcher = this.value.startsWith("[param:") || this.value.contains("\"") ? valueEvalInPat.matcher(this.value) : valueEvalInNumericPat.matcher(this.value);
                StringBuilder parsedVal = new StringBuilder();
                ArrayList<String> values = new ArrayList<String>();
                while (matcher.find()) {
                    String v;
                    boolean quote;
                    if (parsedVal.length() > 0) {
                        parsedVal.append("|");
                    }
                    if (quote = (v = matcher.group(1)).contains("|")) {
                        parsedVal.append("\"");
                    }
                    parsedVal.append(v);
                    values.add(v);
                    if (!quote) continue;
                    parsedVal.append("\"");
                }
                if (parsedVal.length() != 0) {
                    this.value = parsedVal.toString();
                    this.valueArray = values.toArray(EMPTY_STRING_ARRAY);
                } else {
                    this.valueArray = new String[]{this.value};
                }
            } else {
                matcher = valueEvalPat.matcher(this.value);
                if (matcher.find()) {
                    this.value = matcher.group(1);
                }
                this.valueArray = new String[]{this.value};
            }
        }
        this.c.setValue(this.value);
        if (this.fieldName != null && this.fieldName.indexOf(".") > -1) {
            String[] pair = this.fieldName.split("\\.");
            this.catId = pair[0];
            this.colId = pair[1];
            this.aggType = pair.length > 2 ? pair[2] : null;
        }
    }

    public Condition getCondition() {
        return this.c;
    }

    public String[] getValueAsArray() {
        return this.valueArray;
    }

    public String getColID() {
        return this.colId;
    }

    public String getCatID() {
        return this.catId;
    }

    public String getAggType() {
        return this.aggType;
    }
}

