/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class CastStringToIntervalYearMonth
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumn;
    private int outputColumn;

    public CastStringToIntervalYearMonth() {
    }

    public CastStringToIntervalYearMonth(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        if (n == 0) {
            return;
        }
        if (inV.noNulls) {
            outV.noNulls = true;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                this.evaluate(outV, inV, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.evaluate(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.evaluate(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inV.isNull[0];
                if (!inV.isNull[0]) {
                    this.evaluate(outV, inV, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inV.isNull[i];
                    if (inV.isNull[i]) continue;
                    this.evaluate(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    this.evaluate(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        }
    }

    private void evaluate(LongColumnVector outV, BytesColumnVector inV, int i) {
        try {
            HiveIntervalYearMonth interval = HiveIntervalYearMonth.valueOf((String)new String(inV.vector[i], inV.start[i], inV.length[i], "UTF-8"));
            outV.vector[i] = interval.getTotalMonths();
        }
        catch (Exception e) {
            outV.vector[i] = 1L;
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String getOutputType() {
        return "interval_year_month";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

