/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;

    public ExplainSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        FetchTask fetchTask;
        boolean extended = false;
        boolean formatted = false;
        boolean dependency = false;
        boolean logical = false;
        boolean authorize = false;
        for (int i = 1; i < ast.getChildCount(); ++i) {
            int explainOptions = ast.getChild(i).getType();
            if (explainOptions == 123) {
                formatted = true;
                continue;
            }
            if (explainOptions == 110) {
                extended = true;
                continue;
            }
            if (explainOptions == 90) {
                dependency = true;
                continue;
            }
            if (explainOptions == 169) {
                logical = true;
                continue;
            }
            if (explainOptions != 39) continue;
            authorize = true;
        }
        this.ctx.setExplain(true);
        this.ctx.setExplainLogical(logical);
        ASTNode input = (ASTNode)ast.getChild(0);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        List<Task<Serializable>> tasks = sem.getAllRootTasks();
        if (tasks == null) {
            tasks = Collections.emptyList();
        }
        if ((fetchTask = sem.getFetchTask()) != null) {
            ((FetchWork)fetchTask.getWork()).initializeForFetch(this.ctx.getOpContext());
        }
        ParseContext pCtx = null;
        if (sem instanceof SemanticAnalyzer) {
            pCtx = ((SemanticAnalyzer)sem).getParseContext();
        }
        boolean userLevelExplain = !extended && !formatted && !dependency && !logical && !authorize && HiveConf.getBoolVar((Configuration)this.ctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXPLAIN_USER) && HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez");
        ExplainWork work = new ExplainWork(this.ctx.getResFile(), pCtx, tasks, fetchTask, sem, extended, formatted, dependency, logical, authorize, userLevelExplain, this.ctx.getCboInfo());
        work.setAppendTaskType(HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEEXPLAINDEPENDENCYAPPENDTASKTYPES));
        ExplainTask explTask = (ExplainTask)TaskFactory.get(work, this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }

    @Override
    public boolean skipAuthorization() {
        List<Task<? extends Serializable>> rootTasks = this.getRootTasks();
        assert (rootTasks != null && rootTasks.size() == 1);
        Task<? extends Serializable> task = rootTasks.get(0);
        return task instanceof ExplainTask && ((ExplainWork)((ExplainTask)task).getWork()).isAuthorize();
    }
}

