/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkSortMergeJoinFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.parse.spark.SparkSMBMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenSparkUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenSparkUtils.class.getName());
    private int sequenceNumber = 0;
    private static GenSparkUtils utils;

    public static GenSparkUtils getUtils() {
        if (utils == null) {
            utils = new GenSparkUtils();
        }
        return utils;
    }

    protected GenSparkUtils() {
    }

    public void resetSequenceNumber() {
        this.sequenceNumber = 0;
    }

    public ReduceWork createReduceWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork) throws SemanticException {
        Preconditions.checkArgument((!root.getParentOperators().isEmpty() ? 1 : 0) != 0, (Object)"AssertionError: expected root.getParentOperators() to be non-empty");
        ReduceWork reduceWork = new ReduceWork("Reducer " + ++this.sequenceNumber);
        LOG.debug("Adding reduce work (" + reduceWork.getName() + ") for " + root);
        reduceWork.setReducer(root);
        reduceWork.setNeedsTagging(GenMapRedUtils.needsTagging(reduceWork));
        Preconditions.checkArgument((boolean)(context.parentOfRoot instanceof ReduceSinkOperator), (Object)("AssertionError: expected context.parentOfRoot to be an instance of ReduceSinkOperator, but was " + context.parentOfRoot.getClass().getName()));
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)context.parentOfRoot;
        reduceWork.setNumReduceTasks(((ReduceSinkDesc)reduceSink.getConf()).getNumReducers());
        this.setupReduceSink(context, reduceWork, reduceSink);
        sparkWork.add(reduceWork);
        SparkEdgeProperty edgeProp = GenSparkUtils.getEdgeProperty(reduceSink, reduceWork);
        sparkWork.connect(context.preceedingWork, reduceWork, edgeProp);
        return reduceWork;
    }

    protected void setupReduceSink(GenSparkProcContext context, ReduceWork reduceWork, ReduceSinkOperator reduceSink) {
        LOG.debug("Setting up reduce sink: " + reduceSink + " with following reduce work: " + reduceWork.getName());
        GenMapRedUtils.setKeyAndValueDesc(reduceWork, reduceSink);
        reduceWork.getTagToInput().put(((ReduceSinkDesc)reduceSink.getConf()).getTag(), context.preceedingWork.getName());
        ((ReduceSinkDesc)reduceSink.getConf()).setOutputName(reduceWork.getName());
    }

    public MapWork createMapWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork, PrunedPartitionList partitions) throws SemanticException {
        return this.createMapWork(context, root, sparkWork, partitions, false);
    }

    public MapWork createMapWork(GenSparkProcContext context, Operator<?> root, SparkWork sparkWork, PrunedPartitionList partitions, boolean deferSetup) throws SemanticException {
        Preconditions.checkArgument((boolean)root.getParentOperators().isEmpty(), (Object)"AssertionError: expected root.getParentOperators() to be empty");
        MapWork mapWork = new MapWork("Map " + ++this.sequenceNumber);
        LOG.debug("Adding map work (" + mapWork.getName() + ") for " + root);
        Preconditions.checkArgument((boolean)(root instanceof TableScanOperator), (Object)("AssertionError: expected root to be an instance of TableScanOperator, but was " + root.getClass().getName()));
        String alias = ((TableScanDesc)((TableScanOperator)root).getConf()).getAlias();
        if (!deferSetup) {
            this.setupMapWork(mapWork, context, partitions, (TableScanOperator)root, alias);
        }
        sparkWork.add(mapWork);
        return mapWork;
    }

    protected void setupMapWork(MapWork mapWork, GenSparkProcContext context, PrunedPartitionList partitions, TableScanOperator root, String alias) throws SemanticException {
        GenMapRedUtils.setMapWork(mapWork, context.parseContext, context.inputs, partitions, root, alias, context.conf, false);
    }

    private void collectOperators(Operator<?> op, List<Operator<?>> opList) {
        opList.add(op);
        for (Operator<OperatorDesc> child : op.getChildOperators()) {
            if (child == null) continue;
            this.collectOperators(child, opList);
        }
    }

    public void removeUnionOperators(GenSparkProcContext context, BaseWork work) throws SemanticException {
        ArrayList roots = new ArrayList();
        if (work instanceof MapWork) {
            roots.addAll(((MapWork)work).getAliasToWork().values());
        } else {
            roots.addAll(work.getAllRootOperators());
        }
        if (work.getDummyOps() != null) {
            roots.addAll(work.getDummyOps());
        }
        List<Operator<?>> newRoots = SerializationUtilities.cloneOperatorTree(roots);
        Iterator<Operator<?>> newRootsIt = newRoots.iterator();
        for (Operator operator : roots) {
            Operator<?> newRoot = newRootsIt.next();
            LinkedList newOpQueue = new LinkedList();
            this.collectOperators(newRoot, newOpQueue);
            LinkedList linkedList = new LinkedList();
            this.collectOperators(operator, linkedList);
            Iterator newOpQueueIt = newOpQueue.iterator();
            for (Operator operator2 : linkedList) {
                Operator newOp = (Operator)newOpQueueIt.next();
                if (context.rootToWorkMap.containsKey(operator2)) {
                    context.rootToWorkMap.put(newOp, context.rootToWorkMap.get(operator2));
                }
                if (operator2 instanceof FileSinkOperator) {
                    List<FileSinkOperator> fileSinkList = context.fileSinkMap.get(operator2);
                    if (fileSinkList == null) {
                        fileSinkList = new LinkedList<FileSinkOperator>();
                    }
                    fileSinkList.add((FileSinkOperator)newOp);
                    context.fileSinkMap.put((FileSinkOperator)operator2, fileSinkList);
                    continue;
                }
                if (!(operator2 instanceof SparkPartitionPruningSinkOperator)) continue;
                SparkPartitionPruningSinkOperator oldPruningSink = (SparkPartitionPruningSinkOperator)operator2;
                SparkPartitionPruningSinkOperator newPruningSink = (SparkPartitionPruningSinkOperator)newOp;
                ((SparkPartitionPruningSinkDesc)newPruningSink.getConf()).setTableScan(((SparkPartitionPruningSinkDesc)oldPruningSink.getConf()).getTableScan());
                context.pruningSinkSet.add(newPruningSink);
                context.pruningSinkSet.remove(oldPruningSink);
            }
        }
        HashMap replacementMap = new HashMap();
        LinkedList<HashTableDummyOperator> linkedList = new LinkedList<HashTableDummyOperator>();
        Iterator<Operator<?>> it = newRoots.iterator();
        for (Operator operator : roots) {
            Operator<?> newRoot = it.next();
            if (newRoot instanceof HashTableDummyOperator) {
                linkedList.add((HashTableDummyOperator)newRoot);
                it.remove();
                continue;
            }
            replacementMap.put(operator, newRoot);
        }
        LinkedList operators = new LinkedList();
        operators.addAll(newRoots);
        HashSet<Operator> hashSet = new HashSet<Operator>();
        while (!operators.isEmpty()) {
            Operator current = (Operator)operators.pop();
            hashSet.add(current);
            if (current instanceof UnionOperator) {
                Operator<OperatorDesc> parent = null;
                int n = 0;
                for (Operator<OperatorDesc> op : current.getParentOperators()) {
                    if (!hashSet.contains(op)) continue;
                    ++n;
                    parent = op;
                }
                Preconditions.checkArgument((n <= 1 ? 1 : 0) != 0, (Object)("AssertionError: expected count to be <= 1, but was " + n));
                if (parent == null) {
                    replacementMap.put(current, current.getChildOperators().get(0));
                } else {
                    parent.removeChildAndAdoptItsChildren(current);
                }
            }
            if (current instanceof FileSinkOperator || current instanceof ReduceSinkOperator) {
                current.setChildOperators(null);
                continue;
            }
            operators.addAll(current.getChildOperators());
        }
        work.setDummyOps(linkedList);
        work.replaceRoots(replacementMap);
    }

    public void processFileSink(GenSparkProcContext context, FileSinkOperator fileSink) throws SemanticException {
        FetchTask fetchTask;
        ParseContext parseContext = context.parseContext;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseContext, fileSink);
        HiveConf hconf = parseContext.getConf();
        boolean chDir = GenMapRedUtils.isMergeRequired(context.moveTask, hconf, fileSink, context.currentTask, isInsertTable);
        List<FileSinkOperator> fileSinkList = context.fileSinkMap.get(fileSink);
        if (fileSinkList != null) {
            for (FileSinkOperator fsOp : fileSinkList) {
                ((FileSinkDesc)fsOp.getConf()).setGatherStats(((FileSinkDesc)fileSink.getConf()).isGatherStats());
                ((FileSinkDesc)fsOp.getConf()).setStatsReliable(((FileSinkDesc)fileSink.getConf()).isStatsReliable());
            }
        }
        Path finalName = GenMapRedUtils.createMoveTask(context.currentTask, chDir, fileSink, parseContext, context.moveTask, hconf, context.dependencyTask);
        if (chDir) {
            LOG.info("using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fileSink, finalName, context.dependencyTask, context.moveTask, hconf, context.currentTask);
        }
        if ((fetchTask = parseContext.getFetchTask()) != null && context.currentTask.getNumChild() == 0 && fetchTask.isFetchFrom((FileSinkDesc)fileSink.getConf())) {
            context.currentTask.setFetchSource(true);
        }
    }

    public void processPartitionPruningSink(GenSparkProcContext context, SparkPartitionPruningSinkOperator pruningSink) {
        SparkPartitionPruningSinkDesc desc = (SparkPartitionPruningSinkDesc)pruningSink.getConf();
        TableScanOperator ts = desc.getTableScan();
        MapWork targetWork = (MapWork)context.rootToWorkMap.get(ts);
        Preconditions.checkArgument((targetWork != null ? 1 : 0) != 0, (Object)("No targetWork found for tablescan " + ts));
        String targetId = SparkUtilities.getWorkId(targetWork);
        BaseWork sourceWork = this.getEnclosingWork(pruningSink, context);
        String sourceId = SparkUtilities.getWorkId(sourceWork);
        Path tmpPath = targetWork.getTmpPathForPartitionPruning();
        if (tmpPath == null) {
            Path baseTmpPath = context.parseContext.getContext().getMRTmpPath();
            tmpPath = SparkUtilities.generateTmpPathForPartitionPruning(baseTmpPath, targetId);
            targetWork.setTmpPathForPartitionPruning(tmpPath);
            LOG.info("Setting tmp path between source work and target work:\n" + tmpPath);
        }
        desc.setPath(new Path(tmpPath, sourceId));
        desc.setTargetWork(targetWork.getName());
        if (!targetWork.getEventSourceTableDescMap().containsKey(sourceId)) {
            targetWork.getEventSourceTableDescMap().put(sourceId, new LinkedList());
        }
        List<TableDesc> tables = targetWork.getEventSourceTableDescMap().get(sourceId);
        tables.add(((SparkPartitionPruningSinkDesc)pruningSink.getConf()).getTable());
        if (!targetWork.getEventSourceColumnNameMap().containsKey(sourceId)) {
            targetWork.getEventSourceColumnNameMap().put(sourceId, new LinkedList());
        }
        List<String> columns = targetWork.getEventSourceColumnNameMap().get(sourceId);
        columns.add(desc.getTargetColumnName());
        if (!targetWork.getEventSourcePartKeyExprMap().containsKey(sourceId)) {
            targetWork.getEventSourcePartKeyExprMap().put(sourceId, new LinkedList());
        }
        List<ExprNodeDesc> keys = targetWork.getEventSourcePartKeyExprMap().get(sourceId);
        keys.add(desc.getPartKey());
    }

    public static SparkEdgeProperty getEdgeProperty(ReduceSinkOperator reduceSink, ReduceWork reduceWork) throws SemanticException {
        String bucketCount;
        FileSinkOperator fso;
        SparkEdgeProperty edgeProperty = new SparkEdgeProperty(0L);
        edgeProperty.setNumPartitions(reduceWork.getNumReduceTasks());
        String sortOrder = Strings.nullToEmpty((String)((ReduceSinkDesc)reduceSink.getConf()).getOrder()).trim();
        if (GenSparkUtils.hasGBYOperator(reduceSink)) {
            edgeProperty.setShuffleGroup();
            if (!sortOrder.isEmpty() && GenSparkUtils.groupByNeedParLevelOrder(reduceSink)) {
                edgeProperty.setMRShuffle();
            }
        }
        if (reduceWork.getReducer() instanceof JoinOperator) {
            edgeProperty.setMRShuffle();
        }
        if ((fso = GenSparkUtils.getChildOperator(reduceWork.getReducer(), FileSinkOperator.class)) != null && (bucketCount = ((FileSinkDesc)fso.getConf()).getTableInfo().getProperties().getProperty("bucket_count")) != null && Integer.parseInt(bucketCount) > 1) {
            edgeProperty.setMRShuffle();
        }
        if (edgeProperty.isShuffleNone() && !sortOrder.isEmpty()) {
            if ((((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols() == null || ((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols().isEmpty() || GenSparkUtils.isSame(((ReduceSinkDesc)reduceSink.getConf()).getPartitionCols(), ((ReduceSinkDesc)reduceSink.getConf()).getKeyCols())) && ((ReduceSinkDesc)reduceSink.getConf()).hasOrderBy()) {
                edgeProperty.setShuffleSort();
            } else {
                edgeProperty.setMRShuffle();
            }
        }
        if (edgeProperty.isShuffleNone()) {
            edgeProperty.setShuffleGroup();
        }
        return edgeProperty;
    }

    private static boolean groupByNeedParLevelOrder(ReduceSinkOperator reduceSinkOperator) {
        if (((ReduceSinkDesc)reduceSinkOperator.getConf()).isDeduplicated()) {
            return true;
        }
        List<Operator<OperatorDesc>> children = reduceSinkOperator.getChildOperators();
        if (children != null && children.size() == 1 && children.get(0) instanceof GroupByOperator) {
            GroupByOperator child = (GroupByOperator)children.get(0);
            if (GenSparkUtils.isSame(((ReduceSinkDesc)reduceSinkOperator.getConf()).getKeyCols(), ((ReduceSinkDesc)reduceSinkOperator.getConf()).getPartitionCols()) && ((ReduceSinkDesc)reduceSinkOperator.getConf()).getKeyCols().size() == ((GroupByDesc)child.getConf()).getKeys().size()) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSame(List<ExprNodeDesc> list1, List<ExprNodeDesc> list2) {
        if (list1 != list2) {
            if (list1 != null && list2 != null) {
                if (list1.size() != list2.size()) {
                    return false;
                }
                for (int i = 0; i < list1.size(); ++i) {
                    if (list1.get(i).isSame(list2.get(i))) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static <T> T getChildOperator(Operator<?> op, Class<T> klazz) throws SemanticException {
        if (klazz.isInstance(op)) {
            return (T)op;
        }
        List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
        for (Operator<OperatorDesc> childOp : childOperators) {
            T result = GenSparkUtils.getChildOperator(childOp, klazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void annotateMapWork(GenSparkProcContext context) throws SemanticException {
        for (SMBMapJoinOperator smbMapJoinOp : context.smbMapJoinCtxMap.keySet()) {
            SparkSMBMapJoinInfo smbMapJoinInfo = context.smbMapJoinCtxMap.get(smbMapJoinOp);
            MapWork work = smbMapJoinInfo.mapWork;
            SparkSortMergeJoinFactory.annotateMapWork(context, work, smbMapJoinOp, (TableScanOperator)smbMapJoinInfo.bigTableRootOp, false);
            for (Operator<?> smallTableRootOp : smbMapJoinInfo.smallTableRootOps) {
                SparkSortMergeJoinFactory.annotateMapWork(context, work, smbMapJoinOp, (TableScanOperator)smallTableRootOp, true);
            }
        }
    }

    public synchronized int getNextSeqNumber() {
        return ++this.sequenceNumber;
    }

    private static boolean hasGBYOperator(ReduceSinkOperator rs) {
        if (rs.getChildOperators().size() == 1) {
            if (rs.getChildOperators().get(0) instanceof GroupByOperator) {
                return true;
            }
            if (rs.getChildOperators().get(0) instanceof ForwardOperator) {
                for (Operator<OperatorDesc> grandChild : rs.getChildOperators().get(0).getChildOperators()) {
                    if (grandChild instanceof GroupByOperator) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public BaseWork getEnclosingWork(Operator<?> op, GenSparkProcContext procCtx) {
        ArrayList ops = new ArrayList();
        this.findRoots(op, ops);
        for (Operator operator : ops) {
            BaseWork work = procCtx.rootToWorkMap.get(operator);
            if (work == null) continue;
            return work;
        }
        return null;
    }

    private void findRoots(Operator<?> op, List<Operator<?>> ops) {
        List<Operator<OperatorDesc>> parents = op.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            ops.add(op);
            return;
        }
        for (Operator<OperatorDesc> p : parents) {
            this.findRoots(p, ops);
        }
    }
}

