/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="substring_index", value="_FUNC_(str, delim, count) - Returns the substring from string str before count occurrences of the delimiter delim.", extended="If count is positive, everything to the left of the final delimiter (counting from the left) is returned. If count is negative, everything to the right of the final delimiter (counting from the right) is returned. Substring_index performs a case-sensitive match when searching for delim.\nExample:\n > SELECT _FUNC_('www.apache.org', '.', 2);\n 'www.apache'")
public class GenericUDFSubstringIndex
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[3];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[3];
    private final Text output = new Text();
    private transient String delimConst;
    private transient boolean isDelimConst;
    private transient Integer countConst;
    private transient boolean isCountConst;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 3, 3);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgPrimitive(arguments, 2);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
        this.checkArgGroups(arguments, 2, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP);
        this.obtainStringConverter(arguments, 0, this.inputTypes, this.converters);
        this.obtainStringConverter(arguments, 1, this.inputTypes, this.converters);
        this.obtainIntConverter(arguments, 2, this.inputTypes, this.converters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            this.delimConst = this.getConstantStringValue(arguments, 1);
            this.isDelimConst = true;
        }
        if (arguments[2] instanceof ConstantObjectInspector) {
            this.countConst = this.getConstantIntValue(arguments, 2);
            this.isCountConst = true;
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int idx;
        String str = this.getStringValue(arguments, 0, this.converters);
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            this.output.set("");
            return this.output;
        }
        String delim = this.isDelimConst ? this.delimConst : this.getStringValue(arguments, 1, this.converters);
        if (delim == null) {
            return null;
        }
        if (delim.length() == 0) {
            this.output.set("");
            return this.output;
        }
        Integer countV = this.isCountConst ? this.countConst : this.getIntValue(arguments, 2, this.converters);
        if (countV == null) {
            return null;
        }
        int count = countV;
        if (count == 0) {
            this.output.set("");
            return this.output;
        }
        String res = count > 0 ? ((idx = StringUtils.ordinalIndexOf((String)str, (String)delim, (int)count)) != -1 ? str.substring(0, idx) : str) : ((idx = StringUtils.lastOrdinalIndexOf((String)str, (String)delim, (int)(-count))) != -1 ? str.substring(idx + 1) : str);
        this.output.set(res);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "substring_index";
    }
}

