/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounter;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

public abstract class AbstractMessageResponseTimeInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractMessageResponseTimeInterceptor.class);
    private static final String QUESTION_MARK = "?";
    private static final String ESCAPED_QUESTION_MARK = "\\?";

    AbstractMessageResponseTimeInterceptor(String phase) {
        super(phase);
    }

    protected boolean isClient(Message msg) {
        return msg == null ? false : Boolean.TRUE.equals(msg.get((Object)"org.apache.cxf.client"));
    }

    protected void beginHandlingMessage(Exchange ex) {
        if (null == ex) {
            return;
        }
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.beginHandling();
        } else {
            mhtr = new MessageHandlingTimeRecorder(ex);
            mhtr.beginHandling();
        }
    }

    protected void endHandlingMessage(Exchange ex) {
        if (null == ex) {
            return;
        }
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.endHandling();
            mhtr.setFaultMode((FaultMode)ex.get(FaultMode.class));
            this.increaseCounter(ex, mhtr);
        }
    }

    protected void setOneWayMessage(Exchange ex) {
        MessageHandlingTimeRecorder mhtr = (MessageHandlingTimeRecorder)ex.get(MessageHandlingTimeRecorder.class);
        if (null == mhtr) {
            mhtr = new MessageHandlingTimeRecorder(ex);
        } else {
            mhtr.endHandling();
        }
        mhtr.setOneWay(true);
        this.increaseCounter(ex, mhtr);
    }

    private void increaseCounter(Exchange ex, MessageHandlingTimeRecorder mhtr) {
        CounterRepository cr;
        Bus bus = (Bus)ex.get(Bus.class);
        if (null == bus) {
            LOG.log(Level.INFO, "CAN_NOT_GET_BUS_FROM_EXCHANGE");
            bus = BusFactory.getThreadDefaultBus();
        }
        if (null == (cr = (CounterRepository)bus.getExtension(CounterRepository.class))) {
            LOG.log(Level.WARNING, "NO_COUNTER_REPOSITORY");
            return;
        }
        ObjectName serviceCountername = this.getServiceCounterName(ex);
        cr.increaseCounter(serviceCountername, mhtr);
        ObjectName operationCounter = this.getOperationCounterName(ex, serviceCountername);
        cr.increaseCounter(operationCounter, mhtr);
    }

    protected ObjectName getServiceCounterName(Exchange ex) {
        Bus bus = (Bus)ex.get(Bus.class);
        StringBuilder buffer = new StringBuilder();
        ObjectName serviceCounterName = null;
        if (ex.get((Object)"org.apache.cxf.management.service.counter.name") != null) {
            buffer.append((String)ex.get((Object)"org.apache.cxf.management.service.counter.name"));
            try {
                serviceCounterName = new ObjectName(buffer.toString());
            }
            catch (MalformedObjectNameException e) {
                LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", e);
            }
        } else {
            Service service = (Service)ex.get(Service.class);
            Endpoint endpoint = (Endpoint)ex.get(Endpoint.class);
            serviceCounterName = (ObjectName)endpoint.get((Object)"javax.management.ObjectName");
            if (serviceCounterName == null) {
                String serviceName = "\"" + this.escapePatternChars(service.getName().toString()) + "\"";
                String portName = "\"" + endpoint.getEndpointInfo().getName().getLocalPart() + "\"";
                buffer.append("org.apache.cxf:");
                buffer.append("bus.id=" + bus.getId() + ",");
                Message message = ex.getOutMessage();
                if (this.isClient(message)) {
                    buffer.append("type=Performance.Counter.Client,");
                } else {
                    buffer.append("type=Performance.Counter.Server,");
                }
                buffer.append("service=" + serviceName + ",");
                buffer.append("port=" + portName);
                try {
                    serviceCounterName = new ObjectName(buffer.toString());
                    endpoint.put((Object)"javax.management.ObjectName", (Object)serviceCounterName);
                }
                catch (MalformedObjectNameException e) {
                    LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", e);
                }
            }
        }
        return serviceCounterName;
    }

    protected boolean isServiceCounterEnabled(Exchange ex) {
        Bus bus = (Bus)ex.get(Bus.class);
        CounterRepository counterRepo = (CounterRepository)bus.getExtension(CounterRepository.class);
        if (counterRepo == null) {
            return false;
        }
        ObjectName serviceCounterName = this.getServiceCounterName(ex);
        ResponseTimeCounter serviceCounter = (ResponseTimeCounter)counterRepo.getCounter(serviceCounterName);
        return serviceCounter == null || serviceCounter.isEnabled();
    }

    protected ObjectName getOperationCounterName(Exchange ex, ObjectName sericeCounterName) {
        Object nameProperty;
        String operationName;
        ObjectName o;
        OperationInfo opInfo;
        BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        OperationInfo operationInfo = opInfo = bop == null ? null : bop.getOperationInfo();
        if (opInfo != null && (o = (ObjectName)opInfo.getProperty("javax.management.ObjectName", ObjectName.class)) != null) {
            return o;
        }
        String string = operationName = opInfo == null ? null : "\"" + opInfo.getName().getLocalPart() + "\"";
        if (operationName == null && (nameProperty = ex.get((Object)"org.apache.cxf.resource.operation.name")) != null) {
            operationName = "\"" + this.escapePatternChars(nameProperty.toString()) + "\"";
        }
        StringBuilder buffer = new StringBuilder(sericeCounterName.toString());
        if (operationName != null) {
            buffer.append(",operation=" + operationName);
        }
        String operationCounterName = buffer.toString();
        ObjectName operationCounter = null;
        try {
            operationCounter = new ObjectName(operationCounterName);
            if (opInfo != null) {
                opInfo.setProperty("javax.management.ObjectName", (Object)operationCounter);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", e);
        }
        return operationCounter;
    }

    protected String escapePatternChars(String value) {
        if (value.lastIndexOf(QUESTION_MARK) != -1) {
            value = value.replace(QUESTION_MARK, ESCAPED_QUESTION_MARK);
        }
        return value;
    }
}

