/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.monitoring.snmp;

public interface IVariableSerializer {
    public Integer serializeToInt(Object var1);

    public String serializeToString(Object var1);

    public static class BasicSerializer
    implements IVariableSerializer {
        @Override
        public Integer serializeToInt(Object o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            try {
                return Integer.parseInt(o.toString());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public String serializeToString(Object o) {
            return o != null ? o.toString() : "";
        }
    }
}

