/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.luciddbstreamingloader;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbstreamingloader.LucidDBStreamingLoaderData;
import org.pentaho.di.trans.steps.luciddbstreamingloader.LucidDBStreamingLoaderMeta;

public class LucidDBStreamingLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LucidDBStreamingLoaderMeta.class;
    private LucidDBStreamingLoaderMeta meta;
    private LucidDBStreamingLoaderData data;

    public LucidDBStreamingLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (LucidDBStreamingLoaderMeta)smi;
        this.data = (LucidDBStreamingLoaderData)sdi;
        if (this.data.objOut != null) {
            try {
                this.data.objOut.flush();
                this.data.objOut.close();
            }
            catch (IOException e) {
                this.logError("Error while closing Remote LucidDB connection - likely already closed by earlier exception");
            }
            finally {
                this.data.objOut = null;
            }
            if (this.data.client != null) {
                try {
                    this.data.client.close();
                }
                catch (IOException e) {
                    this.logError("Error while closing Remote client connection - likely already closed by earlier exception");
                }
                finally {
                    this.data.client = null;
                }
            }
        }
        try {
            if (this.data.sqlRunner != null) {
                this.data.sqlRunner.join();
            }
        }
        catch (InterruptedException e) {
            this.logError("Error while trying to rejoin/end SQLRunner thread from LucidDB");
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (LucidDBStreamingLoaderMeta)smi;
        this.data = (LucidDBStreamingLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                if (this.data.objOut != null) {
                    this.data.objOut.flush();
                    this.data.objOut.close();
                    if (this.data.client != null) {
                        this.data.client.close();
                    }
                }
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                if (this.meta.getOperation() != LucidDBStreamingLoaderMeta.OPERATION_CUSTOM) {
                    String qualifiedTableName;
                    if (this.log.isDebug()) {
                        this.logDebug("Connected to LucidDB");
                    }
                    if (!this.data.db.checkTableExists(qualifiedTableName = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName())))) {
                        throw new KettleException("Error: Table " + qualifiedTableName + " doesn't existing in LucidDB");
                    }
                }
                String sql = this.meta.getDMLStatement((VariableSpace)this, this.getInputRowMeta());
                PreparedStatement ps = this.data.db.prepareSQL(sql);
                if (this.log.isDebug()) {
                    this.logDebug("Executing sql statements...");
                }
                this.data.sqlRunner = new SqlRunner(this.data, ps);
                this.data.sqlRunner.start();
                if (this.log.isDebug()) {
                    this.logDebug("Remote rows is up now...");
                }
                if (this.log.isDebug()) {
                    this.logDebug("Sleeping for 1 second");
                }
                Thread.sleep(1000L);
                if (this.log.isDebug()) {
                    this.logDebug("Initialize local socket connection...");
                }
                if (this.log.isDebug()) {
                    this.logDebug("Parameters for socket: Host: " + this.meta.getHost() + " Port: " + this.meta.getPort());
                }
                int try_cnt = 0;
                while (true) {
                    try {
                        this.data.client = new Socket(this.meta.getHost(), (int)Integer.valueOf(this.meta.getPort()));
                        this.data.objOut = new ObjectOutputStream(this.data.client.getOutputStream());
                        if (!this.log.isDebug()) break;
                        this.logDebug("Local socket connection is ready");
                    }
                    catch (SocketException se) {
                        if (try_cnt < 5) {
                            this.logBasic("Local socket connection is not ready, so try to connect in 5 second");
                            Thread.sleep(5000L);
                            this.data.client = null;
                            ++try_cnt;
                            continue;
                        }
                        throw new KettleException("Fatal Error: Remote_rows UDX can't be connected! Please check...");
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                    break;
                }
                ArrayList<String> combined = new ArrayList<String>();
                for (i = 0; i < this.meta.getFieldStreamForKeys().length; ++i) {
                    combined.add(this.meta.getFieldStreamForKeys()[i]);
                }
                for (i = 0; i < this.meta.getFieldStreamForFields().length; ++i) {
                    if (this.meta.isInKeys(this.meta.getFieldStreamForFields()[i])) continue;
                    combined.add(this.meta.getFieldStreamForFields()[i]);
                }
                this.data.keynrs = new int[combined.size()];
                this.data.format = new String[combined.size()];
                for (i = 0; i < combined.size(); ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue((String)combined.get(i));
                    ValueMetaInterface v = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]);
                    this.data.format[i] = this.meta.getDatabaseMeta().getFieldDefinition(v, null, null, false);
                }
                if (this.isDetailed()) {
                    this.logDetailed(Arrays.toString(this.data.format));
                }
                ArrayList<Object> header = new ArrayList<Object>();
                header.add("1");
                ArrayList<String> format = new ArrayList<String>();
                for (int i2 = 0; i2 < this.data.format.length; ++i2) {
                    format.add(this.data.format[i2]);
                }
                header.add(format);
                this.data.objOut.writeObject(header);
            }
            if (this.data.sqlRunner.ex != null) {
                throw new KettleException((Throwable)this.data.sqlRunner.ex);
            }
            ArrayList<Object> entity = new ArrayList<Object>();
            block19: for (int i = 0; i < this.data.keynrs.length; ++i) {
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
                Object valueData = r[index];
                if (r[i] == null) {
                    entity.add(null);
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 1: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(valueMeta.getNumber(valueData) + ":" + valueMeta.getLength() + ":" + valueMeta.getTypeDesc());
                        }
                        entity.add(valueMeta.getNumber(valueData));
                        continue block19;
                    }
                    case 2: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(valueMeta.getString(valueData) + ":" + valueMeta.getLength() + ":" + valueMeta.getTypeDesc());
                        }
                        entity.add(valueMeta.getString(valueData));
                        continue block19;
                    }
                    case 3: {
                        java.util.Date date = valueMeta.getDate(valueData);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(XMLHandler.date2string((java.util.Date)date) + ":" + valueMeta.getLength());
                        }
                        Date sqlDate = new Date(date.getTime());
                        entity.add(sqlDate);
                        continue block19;
                    }
                    case 4: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(Boolean.toString(valueMeta.getBoolean(valueData)) + ":" + valueMeta.getLength());
                        }
                        entity.add(valueMeta.getBoolean(valueData));
                        continue block19;
                    }
                    case 5: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(valueMeta.getInteger(valueData) + ":" + valueMeta.getLength() + ":" + valueMeta.getTypeDesc());
                        }
                        entity.add(valueMeta.getInteger(valueData));
                        continue block19;
                    }
                    case 6: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(valueMeta.getBigNumber(valueData) + ":" + valueMeta.getLength() + ":" + valueMeta.getTypeDesc());
                        }
                        entity.add(valueMeta.getBigNumber(valueData));
                        continue block19;
                    }
                    case 8: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(valueMeta.getBinary(valueData) + ":" + valueMeta.getLength() + ":" + valueMeta.getTypeDesc());
                        }
                        entity.add(valueMeta.getBinary(valueData));
                        continue block19;
                    }
                    default: {
                        entity.add(r[i]);
                    }
                }
            }
            this.data.objOut.writeObject(entity);
            this.incrementLinesOutput();
            this.data.objOut.reset();
            this.data.objOut.flush();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LucidDBStreamingLoaderMeta)smi;
        this.data = (LucidDBStreamingLoaderData)sdi;
        if (super.init(smi, sdi)) {
            try {
                if (this.log.isDebug()) {
                    this.logDebug("Connecting to LucidDB...");
                }
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderDialog.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                this.data.db.setAutoCommit(true);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.logError(e.getMessage());
                return false;
            }
            catch (KettleDatabaseException e) {
                e.printStackTrace();
                this.logError(e.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LucidDBStreamingLoaderMeta)smi;
        this.data = (LucidDBStreamingLoaderData)sdi;
        try {
            if (this.data.sqlRunner != null) {
                this.data.sqlRunner.join();
                this.data.sqlRunner = null;
            }
            if (this.data.db != null) {
                this.data.db.disconnect();
                this.data.db = null;
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while closing the client connection", e);
        }
        super.dispose(smi, sdi);
    }

    static class SqlRunner
    extends Thread {
        private LucidDBStreamingLoaderData data;
        private PreparedStatement ps;
        private SQLException ex;
        List<String> warnings;

        SqlRunner(LucidDBStreamingLoaderData data, PreparedStatement ps) {
            this.data = data;
            this.ps = ps;
            this.warnings = new ArrayList<String>();
            this.ex = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            this.ps.executeUpdate();
            for (SQLWarning warning = this.ps.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.warnings.add(warning.getMessage());
            }
            try {
                this.data.db.closePreparedStatement(this.ps);
            }
            catch (KettleException warning) {
            }
            finally {
                this.ps = null;
            }
            catch (SQLException ex) {
                try {
                    this.ex = ex;
                }
                catch (Throwable throwable) {
                    try {
                        this.data.db.closePreparedStatement(this.ps);
                    }
                    catch (KettleException kettleException) {
                    }
                    finally {
                        this.ps = null;
                    }
                    throw throwable;
                }
                try {
                    this.data.db.closePreparedStatement(this.ps);
                }
                catch (KettleException kettleException) {
                }
                finally {
                    this.ps = null;
                }
            }
        }

        void checkExcn() throws SQLException {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }
}

