/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;

public class EventHandleImp
implements EventHandle {
    private int eventCount = -1;
    private String eventName;
    private int eventId = -1;
    private int localId = -1;
    private int internalCount = 0;
    private int previousInternalCount = 0;

    public EventHandleImp(String eventName) {
        if (eventName == null) {
            throw new NullPointerException();
        }
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    public void setLocalId(int localId) {
        this.localId = localId;
    }

    public int getLocalId() {
        return this.localId;
    }

    public byte[] getParameterBuffer() {
        return new byte[0];
    }

    public String toString() {
        return "EventHandle: internal id = " + this.localId + ", external id = " + this.eventId;
    }

    void setInternalCount(int count) {
        this.internalCount = count;
    }

    synchronized void calculateCount() {
        this.eventCount = this.internalCount - this.previousInternalCount;
        this.previousInternalCount = this.internalCount;
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        XdrOutputStream xdr = new XdrOutputStream(byteOut);
        byte[] eventNameBytes = this.eventName.getBytes();
        xdr.write(1);
        xdr.write(eventNameBytes.length);
        xdr.write(eventNameBytes);
        for (int shift = 0; shift <= 24; shift += 8) {
            xdr.write(this.internalCount >> shift & 0xFF);
        }
        xdr.flush();
        byteOut.flush();
        return byteOut.toByteArray();
    }
}

