/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.bzip2r;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.tools.bzip2r.BZip2Constants;
import org.apache.tools.bzip2r.CRC;

public class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] tt;
    private char[] ll8;
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private FSDataInputStream innerBsStream;
    long readLimit = Long.MAX_VALUE;
    long readCount;
    private boolean streamEnd = false;
    private int currentChar = -1;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private boolean checkComputedCombinedCRC = true;
    int i2;
    int count;
    int chPrev;
    int ch2;
    int i;
    int tPos;
    int rNToGo = 0;
    int rTPos = 0;
    int j2;
    char z;
    private long retPos = -1L;
    private long endOffsetOfSplit;
    private boolean signalToStopReading;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final long eob = 54156738319193L;
    private static final long eos = 25779555029136L;

    private static void cadvise(String reason) throws IOException {
        throw new IOException(reason);
    }

    private static void compressedStreamEOF() throws IOException {
        CBZip2InputStream.cadvise("compressedStream EOF");
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public CBZip2InputStream(FSDataInputStream zStream, int blockSize, long end) throws IOException {
        this.endOffsetOfSplit = end;
        this.retPos = zStream.getPos();
        this.ll8 = null;
        this.tt = null;
        this.checkComputedCombinedCRC = blockSize == -1;
        this.bsSetStream(zStream);
        this.initialize(blockSize);
        this.initBlock(blockSize != -1);
        this.setupBlock();
    }

    @Override
    public int read() throws IOException {
        if (this.innerBsStream == null) {
            throw new IOException("stream closed");
        }
        if (this.streamEnd) {
            return -1;
        }
        if (this.signalToStopReading) {
            this.retPos = this.endOffsetOfSplit + 1L;
        }
        int retChar = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.innerBsStream == null) {
            return;
        }
        try {
            this.innerBsStream.close();
        }
        finally {
            this.innerBsStream = null;
        }
    }

    public long getPos() throws IOException {
        return this.retPos;
    }

    private void initialize(int blockSize) throws IOException {
        if (blockSize == -1) {
            char magic1 = this.bsGetUChar();
            char magic2 = this.bsGetUChar();
            char magic3 = this.bsGetUChar();
            char magic4 = this.bsGetUChar();
            if (magic1 != 'B' || magic2 != 'Z' || magic3 != 'h' || magic4 < '1' || magic4 > '9') {
                this.streamEnd = true;
                return;
            }
            blockSize = magic4 - 48;
        }
        this.setDecompressStructureSizes(blockSize);
        this.computedCombinedCRC = 0;
    }

    private void initBlock(boolean searchForMagic) throws IOException {
        if (this.readCount >= this.readLimit) {
            this.streamEnd = true;
            return;
        }
        long pos = this.innerBsStream.getPos();
        if (!searchForMagic) {
            char magic1 = this.bsGetUChar();
            char magic2 = this.bsGetUChar();
            char magic3 = this.bsGetUChar();
            char magic4 = this.bsGetUChar();
            char magic5 = this.bsGetUChar();
            char magic6 = this.bsGetUChar();
            if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
                this.complete();
                return;
            }
            if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
                CBZip2InputStream.badBlockHeader();
                this.streamEnd = true;
                return;
            }
        } else {
            long magic = 0L;
            for (int i = 0; i < 6; ++i) {
                magic <<= 8;
                magic |= (long)this.bsGetUChar();
            }
            while (magic != 25779555029136L && magic != 54156738319193L) {
                magic <<= 1;
                magic &= 0xFFFFFFFFFFFFL;
                magic |= (long)this.bsR(1);
                pos = this.innerBsStream.getPos() - 6L;
            }
            if (magic == 25779555029136L) {
                this.complete();
                return;
            }
        }
        if (this.bsLive > 0) {
            --pos;
        }
        if (pos >= this.endOffsetOfSplit) {
            this.signalToStopReading = true;
        }
        this.storedBlockCRC = this.bsGetInt32();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() throws IOException {
        this.computedBlockCRC = this.mCrc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void complete() throws IOException {
        this.storedCombinedCRC = this.bsGetInt32();
        if (this.checkComputedCombinedCRC && this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        if (this.innerBsStream.getPos() < this.endOffsetOfSplit) {
            throw new IOException("Encountered additional bytes in the filesplit past the crc block. Loading of concatenated bz2 files is not supported");
        }
        this.streamEnd = true;
    }

    private static void blockOverrun() throws IOException {
        CBZip2InputStream.cadvise("block overrun");
    }

    private static void badBlockHeader() throws IOException {
        CBZip2InputStream.cadvise("bad block header");
    }

    private static void crcError() throws IOException {
        CBZip2InputStream.cadvise("CRC error");
    }

    private void bsSetStream(FSDataInputStream f) {
        this.innerBsStream = f;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private final int readBs() throws IOException {
        ++this.readCount;
        return this.innerBsStream.read();
    }

    private int bsR(int n) throws IOException {
        while (this.bsLive < n) {
            int zzi = this.readBs();
            if (zzi == -1) {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
            this.bsLive += 8;
        }
        int v = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return v;
    }

    private char bsGetUChar() throws IOException {
        return (char)this.bsR(8);
    }

    private int bsGetint() throws IOException {
        int u = 0;
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        u = u << 8 | this.bsR(8);
        return u;
    }

    private int bsGetIntVS(int numBits) throws IOException {
        return this.bsR(numBits);
    }

    private int bsGetInt32() throws IOException {
        return this.bsGetint();
    }

    private void hbCreateDecodeTables(int[] limit, int[] base, int[] perm, char[] length, int minLen, int maxLen, int alphaSize) {
        int i;
        int pp = 0;
        for (i = minLen; i <= maxLen; ++i) {
            for (int j = 0; j < alphaSize; ++j) {
                if (length[j] != i) continue;
                perm[pp] = j;
                ++pp;
            }
        }
        for (i = 0; i < 23; ++i) {
            base[i] = 0;
        }
        for (i = 0; i < alphaSize; ++i) {
            int n = length[i] + '\u0001';
            base[n] = base[n] + 1;
        }
        for (i = 1; i < 23; ++i) {
            int n = i;
            base[n] = base[n] + base[i - 1];
        }
        for (i = 0; i < 23; ++i) {
            limit[i] = 0;
        }
        int vec = 0;
        for (i = minLen; i <= maxLen; ++i) {
            limit[i] = (vec += base[i + 1] - base[i]) - 1;
            vec <<= 1;
        }
        for (i = minLen + 1; i <= maxLen; ++i) {
            base[i] = (limit[i - 1] + 1 << 1) - base[i];
        }
    }

    private void recvDecodingTables() throws IOException {
        int t;
        int v;
        int j;
        int i;
        char[][] len = new char[6][258];
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = this.bsR(1) == 1;
        }
        for (i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.bsR(1) != 1) continue;
                this.inUse[i * 16 + j] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.nInUse + 2;
        int nGroups = this.bsR(3);
        int nSelectors = this.bsR(15);
        for (i = 0; i < nSelectors; ++i) {
            j = 0;
            while (this.bsR(1) == 1) {
                ++j;
            }
            this.selectorMtf[i] = (char)j;
        }
        char[] pos = new char[6];
        for (v = 0; v < nGroups; v = (int)((char)(v + 1))) {
            pos[v] = v;
        }
        for (i = 0; i < nSelectors; ++i) {
            char tmp = pos[v];
            for (v = this.selectorMtf[i]; v > 0; v = (int)((char)(v - 1))) {
                pos[v] = pos[v - 1];
            }
            pos[0] = tmp;
            this.selector[i] = tmp;
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = this.bsR(5);
            for (i = 0; i < alphaSize; ++i) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++curr;
                        continue;
                    }
                    --curr;
                }
                len[t][i] = (char)curr;
            }
        }
        for (t = 0; t < nGroups; ++t) {
            int minLen = 32;
            char maxLen = '\u0000';
            for (i = 0; i < alphaSize; ++i) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] >= minLen) continue;
                minLen = len[t][i];
            }
            this.hbCreateDecodeTables(this.limit[t], this.base[t], this.perm[t], len[t], minLen, maxLen, alphaSize);
            this.minLens[t] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        int i;
        char[] yy = new char[256];
        int limitLast = 100000 * this.blockSize100k;
        this.origPtr = this.bsGetIntVS(24);
        this.recvDecodingTables();
        int EOB = this.nInUse + 1;
        int groupNo = -1;
        int groupPos = 0;
        for (i = 0; i <= 255; ++i) {
            this.unzftab[i] = 0;
        }
        for (i = 0; i <= 255; ++i) {
            yy[i] = (char)i;
        }
        this.last = -1;
        if (groupPos == 0) {
            ++groupNo;
            groupPos = 50;
        }
        --groupPos;
        char zt = this.selector[groupNo];
        int zn = this.minLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.limit[zt][zn]) {
            ++zn;
            while (this.bsLive < 1) {
                int zzi = 0;
                try {
                    zzi = this.readBs();
                }
                catch (IOException e) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (zzi == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                this.bsLive += 8;
            }
            int zj = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.perm[zt][zvec - this.base[zt][zn]];
        while (nextSym != EOB) {
            int j;
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int zn2;
                int zvec2;
                char zt2;
                int s = -1;
                int N = 1;
                do {
                    if (nextSym == 0) {
                        s += 1 * N;
                    } else if (nextSym == 1) {
                        s += 2 * N;
                    }
                    N *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt2 = this.selector[groupNo];
                    zn2 = this.minLens[zt2];
                    zvec2 = this.bsR(zn2);
                    while (zvec2 > this.limit[zt2][zn2]) {
                        ++zn2;
                        while (this.bsLive < 1) {
                            int zzi = 0;
                            try {
                                zzi = this.readBs();
                            }
                            catch (IOException e) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (zzi == -1) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                            this.bsLive += 8;
                        }
                        int zj = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        zvec2 = zvec2 << 1 | zj;
                    }
                } while ((nextSym = this.perm[zt2][zvec2 - this.base[zt2][zn2]]) == 0 || nextSym == 1);
                char c = ch = this.seqToUnseq[yy[0]];
                this.unzftab[c] = this.unzftab[c] + ++s;
                while (s > 0) {
                    ++this.last;
                    this.ll8[this.last] = ch;
                    --s;
                }
                if (this.last < limitLast) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= limitLast) {
                CBZip2InputStream.blockOverrun();
            }
            char tmp = yy[nextSym - 1];
            char c = this.seqToUnseq[tmp];
            this.unzftab[c] = this.unzftab[c] + 1;
            this.ll8[this.last] = this.seqToUnseq[tmp];
            for (j = nextSym - 1; j > 3; j -= 4) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            char zt3 = this.selector[groupNo];
            int zn3 = this.minLens[zt3];
            int zvec3 = this.bsR(zn3);
            while (zvec3 > this.limit[zt3][zn3]) {
                ++zn3;
                while (this.bsLive < 1) {
                    char thech = '\u0000';
                    try {
                        thech = (char)this.readBs();
                    }
                    catch (IOException e) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    char zzi = thech;
                    this.bsBuff = this.bsBuff << 8 | zzi & 0xFF;
                    this.bsLive += 8;
                }
                int zj = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                zvec3 = zvec3 << 1 | zj;
            }
            nextSym = this.perm[zt3][zvec3 - this.base[zt3][zn3]];
        }
    }

    private void setupBlock() throws IOException {
        int[] cftab = new int[257];
        cftab[0] = 0;
        this.i = 1;
        while (this.i <= 256) {
            cftab[this.i] = this.unzftab[this.i - 1];
            ++this.i;
        }
        this.i = 1;
        while (this.i <= 256) {
            int n = this.i;
            cftab[n] = cftab[n] + cftab[this.i - 1];
            ++this.i;
        }
        this.i = 0;
        while (this.i <= this.last) {
            char ch = this.ll8[this.i];
            this.tt[cftab[ch]] = this.i++;
            char c = ch;
            cftab[c] = cftab[c] + 1;
        }
        cftab = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = rNums[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock(false);
            this.setupBlock();
        }
    }

    private void setupNoRandPartA() throws IOException {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.ll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.mCrc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock(false);
            this.setupBlock();
        }
    }

    private void setupRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = rNums[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() throws IOException {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.ll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() throws IOException {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.mCrc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setDecompressStructureSizes(int newSize100k) {
        if (0 > newSize100k || newSize100k > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = newSize100k;
        if (newSize100k == 0) {
            return;
        }
        int n = 100000 * newSize100k;
        this.ll8 = new char[n];
        this.tt = new int[n];
    }
}

