/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.sqoop;

import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceFactory;
import org.pentaho.big.data.impl.shim.sqoop.SqoopServiceImpl;
import org.pentaho.bigdata.api.sqoop.SqoopService;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopServiceFactoryImpl
implements NamedClusterServiceFactory<SqoopService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqoopServiceFactoryImpl.class);
    private final boolean isActiveConfiguration;
    private final HadoopConfiguration hadoopConfiguration;

    public SqoopServiceFactoryImpl(boolean isActiveConfiguration, HadoopConfiguration hadoopConfiguration) {
        this.isActiveConfiguration = isActiveConfiguration;
        this.hadoopConfiguration = hadoopConfiguration;
    }

    public Class<SqoopService> getServiceClass() {
        return SqoopService.class;
    }

    public boolean canHandle(NamedCluster namedCluster) {
        boolean ncState = namedCluster == null ? true : !namedCluster.isUseGateway();
        return this.isActiveConfiguration && ncState;
    }

    public SqoopService create(NamedCluster namedCluster) {
        try {
            HadoopShim hadoopShim = this.hadoopConfiguration.getHadoopShim();
            SqoopShim sqoopShim = this.hadoopConfiguration.getSqoopShim();
            return new SqoopServiceImpl(hadoopShim, sqoopShim, namedCluster);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Unable to load SqoopService for " + namedCluster);
            return null;
        }
    }
}

