/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AutoProgressor;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.UDTFCollector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFOperator
extends Operator<UDTFDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger((String)UDTFOperator.class.getName());
    StructObjectInspector udtfInputOI = null;
    Object[] objToSendToUDTF = null;
    GenericUDTF genericUDTF;
    UDTFCollector collector;
    List outerObj;
    transient AutoProgressor autoProgressor;

    protected UDTFOperator() {
    }

    public UDTFOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.genericUDTF = ((UDTFDesc)this.conf).getGenericUDTF();
        this.collector = new UDTFCollector(this);
        this.genericUDTF.setCollector(this.collector);
        this.udtfInputOI = (StructObjectInspector)this.inputObjInspectors[0];
        this.objToSendToUDTF = new Object[this.udtfInputOI.getAllStructFieldRefs().size()];
        MapredContext context = MapredContext.get();
        if (context != null) {
            context.setup(this.genericUDTF);
        }
        StructObjectInspector udtfOutputOI = this.genericUDTF.initialize(this.udtfInputOI);
        if (((UDTFDesc)this.conf).isOuterLV()) {
            this.outerObj = Arrays.asList(new Object[udtfOutputOI.getAllStructFieldRefs().size()]);
        }
        this.outputObjInspector = udtfOutputOI;
        if (HiveConf.getBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEUDTFAUTOPROGRESS)) {
            this.autoProgressor = new AutoProgressor(this.getClass().getName(), this.reporter, Utilities.getDefaultNotificationInterval(hconf), HiveConf.getTimeVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
            this.autoProgressor.go();
        }
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[tag];
        List fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            this.objToSendToUDTF[i] = soi.getStructFieldData(row, (StructField)fields.get(i));
        }
        this.genericUDTF.process(this.objToSendToUDTF);
        if (((UDTFDesc)this.conf).isOuterLV() && this.collector.getCounter() == 0) {
            this.collector.collect(this.outerObj);
        }
        this.collector.reset();
    }

    public void forwardUDTFOutput(Object o) throws HiveException {
        this.forward(o, this.outputObjInspector);
    }

    @Override
    public String getName() {
        return UDTFOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "UDTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.UDTF;
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        ((UDTFDesc)this.conf).getGenericUDTF().close();
    }
}

