/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class VectorCoalesce
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int[] inputColumns;
    private int outputColumn;

    public VectorCoalesce(int[] inputColumns, int outputColumn) {
        this();
        this.inputColumns = inputColumns;
        this.outputColumn = outputColumn;
        Preconditions.checkArgument((this.inputColumns.length > 0 ? 1 : 0) != 0);
    }

    public VectorCoalesce() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        ColumnVector outputVector = batch.cols[this.outputColumn];
        if (n <= 0) {
            return;
        }
        outputVector.init();
        boolean noNulls = false;
        for (int k = 0; k < this.inputColumns.length; ++k) {
            ColumnVector cv = batch.cols[this.inputColumns[k]];
            noNulls = noNulls || cv.noNulls;
        }
        outputVector.noNulls = noNulls;
        outputVector.isRepeating = false;
        ColumnVector first = batch.cols[this.inputColumns[0]];
        if (first.noNulls && first.isRepeating) {
            outputVector.isRepeating = true;
            outputVector.isNull[0] = false;
            outputVector.setElement(0, 0, first);
        } else if (batch.selectedInUse) {
            block1: for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector cv = batch.cols[this.inputColumns[k]];
                    if (cv.isRepeating && (cv.noNulls || !cv.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.setElement(i, 0, cv);
                        continue block1;
                    }
                    if (cv.isRepeating || !cv.noNulls && cv.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.setElement(i, i, cv);
                    continue block1;
                }
            }
        } else {
            block3: for (int i = 0; i != n; ++i) {
                outputVector.isNull[i] = true;
                for (int k = 0; k < this.inputColumns.length; ++k) {
                    ColumnVector cv = batch.cols[this.inputColumns[k]];
                    if (cv.isRepeating && (cv.noNulls || !cv.isNull[0])) {
                        outputVector.isNull[i] = false;
                        outputVector.setElement(i, 0, cv);
                        continue block3;
                    }
                    if (cv.isRepeating || !cv.noNulls && cv.isNull[i]) continue;
                    outputVector.isNull[i] = false;
                    outputVector.setElement(i, i, cv);
                    continue block3;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    public int[] getInputColumns() {
        return this.inputColumns;
    }

    public void setInputColumns(int[] inputColumns) {
        this.inputColumns = inputColumns;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

