/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hive.common.util.HashCodeUtil;

public abstract class VectorReduceSinkCommonOperator
extends TerminalOperator<ReduceSinkDesc>
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkCommonOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected VectorReduceSinkDesc vectorDesc;
    protected VectorReduceSinkInfo vectorReduceSinkInfo;
    protected VectorizationContext vContext;
    protected int[] reduceSinkKeyColumnMap;
    protected TypeInfo[] reduceSinkKeyTypeInfos;
    protected VectorExpression[] reduceSinkKeyExpressions;
    protected int[] reduceSinkValueColumnMap;
    protected TypeInfo[] reduceSinkValueTypeInfos;
    protected VectorExpression[] reduceSinkValueExpressions;
    private transient boolean reduceSkipTag;
    private transient byte reduceTagByte;
    protected transient BinarySortableSerializeWrite keyBinarySortableSerializeWrite;
    private transient byte[] nullBytes;
    private transient int nullKeyHashCode;
    private transient LazyBinarySerializeWrite valueLazyBinarySerializeWrite;
    private transient VectorSerializeRow<LazyBinarySerializeWrite> valueVectorSerializeRow;
    private transient ByteStream.Output valueOutput;
    private transient HiveKey keyWritable;
    private transient BytesWritable valueBytesWritable;
    private transient OutputCollector out;
    protected transient VectorKeySeriesSerialized serializedKeySeries;
    private transient long numRows = 0L;
    private transient long cntr = 1L;
    private transient long logEveryNRows = 0L;
    private final transient LongWritable recordCounter = new LongWritable();
    protected transient String taskName;
    protected transient long batchCounter;

    protected VectorReduceSinkCommonOperator() {
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this(ctx);
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.vectorDesc = desc.getVectorDesc();
        this.vectorReduceSinkInfo = this.vectorDesc.getVectorReduceSinkInfo();
        this.vContext = vContext;
        this.reduceSinkKeyColumnMap = this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap();
        this.reduceSinkKeyTypeInfos = this.vectorReduceSinkInfo.getReduceSinkKeyTypeInfos();
        this.reduceSinkKeyExpressions = this.vectorReduceSinkInfo.getReduceSinkKeyExpressions();
        this.reduceSinkValueColumnMap = this.vectorReduceSinkInfo.getReduceSinkValueColumnMap();
        this.reduceSinkValueTypeInfos = this.vectorReduceSinkInfo.getReduceSinkValueTypeInfos();
        this.reduceSinkValueExpressions = this.vectorReduceSinkInfo.getReduceSinkValueExpressions();
    }

    private boolean[] getColumnSortOrder(Properties properties, int columnCount) {
        String columnSortOrder = properties.getProperty("serialization.sort.order");
        boolean[] columnSortOrderIsDesc = new boolean[columnCount];
        if (columnSortOrder == null) {
            Arrays.fill(columnSortOrderIsDesc, false);
        } else {
            for (int i = 0; i < columnSortOrderIsDesc.length; ++i) {
                columnSortOrderIsDesc[i] = columnSortOrder.charAt(i) == '-';
            }
        }
        return columnSortOrderIsDesc;
    }

    private byte[] getColumnNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNullMarker[i] = 1;
                    continue;
                }
                columnNullMarker[i] = 0;
                continue;
            }
            columnNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)1 : 0;
        }
        return columnNullMarker;
    }

    private byte[] getColumnNotNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNotNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNotNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNotNullMarker[i] = 0;
                    continue;
                }
                columnNotNullMarker[i] = 1;
                continue;
            }
            columnNotNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)0 : 1;
        }
        return columnNotNullMarker;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        String context;
        super.initializeOp(hconf);
        if (LOG.isDebugEnabled()) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        if ((context = hconf.get("__hive.context.name", "")) != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        this.statsMap.put((Object)((Object)ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE) + context, this.recordCounter);
        this.reduceSkipTag = ((ReduceSinkDesc)this.conf).getSkipTag();
        this.reduceTagByte = (byte)((ReduceSinkDesc)this.conf).getTag();
        if (this.isLogInfoEnabled) {
            LOG.info((Object)("Using tag = " + this.reduceTagByte));
        }
        TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
        boolean[] columnSortOrder = this.getColumnSortOrder(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length);
        byte[] columnNullMarker = this.getColumnNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
        byte[] columnNotNullMarker = this.getColumnNotNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
        this.keyBinarySortableSerializeWrite = new BinarySortableSerializeWrite(columnSortOrder, columnNullMarker, columnNotNullMarker);
        try {
            ByteStream.Output nullKeyOutput = new ByteStream.Output();
            this.keyBinarySortableSerializeWrite.set(nullKeyOutput);
            for (int i = 0; i < this.reduceSinkKeyColumnMap.length; ++i) {
                this.keyBinarySortableSerializeWrite.writeNull();
            }
            int nullBytesLength = nullKeyOutput.getLength();
            this.nullBytes = new byte[nullBytesLength];
            System.arraycopy(nullKeyOutput.getData(), 0, this.nullBytes, 0, nullBytesLength);
            this.nullKeyHashCode = HashCodeUtil.calculateBytesHashCode((byte[])this.nullBytes, (int)0, (int)nullBytesLength);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        this.valueLazyBinarySerializeWrite = new LazyBinarySerializeWrite(this.reduceSinkValueColumnMap.length);
        this.valueVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(this.valueLazyBinarySerializeWrite);
        this.valueVectorSerializeRow.init(this.reduceSinkValueTypeInfos, this.reduceSinkValueColumnMap);
        this.valueOutput = new ByteStream.Output();
        this.valueVectorSerializeRow.setOutput(this.valueOutput);
        this.keyWritable = new HiveKey();
        this.valueBytesWritable = new BytesWritable();
        this.batchCounter = 0L;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            ++this.batchCounter;
            if (batch.size == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.reduceSinkKeyExpressions != null) {
                for (VectorExpression ve : this.reduceSinkKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            if (this.reduceSinkValueExpressions != null) {
                for (VectorExpression ve : this.reduceSinkValueExpressions) {
                    ve.evaluate(batch);
                }
            }
            this.serializedKeySeries.processBatch(batch);
            boolean selectedInUse = batch.selectedInUse;
            int[] selected = batch.selected;
            do {
                if (this.serializedKeySeries.getCurrentIsAllNull()) {
                    if (tag == -1 || this.reduceSkipTag) {
                        this.keyWritable.set(this.nullBytes, 0, this.nullBytes.length);
                    } else {
                        this.keyWritable.setSize(this.nullBytes.length + 1);
                        System.arraycopy(this.nullBytes, 0, this.keyWritable.get(), 0, this.nullBytes.length);
                        this.keyWritable.get()[this.nullBytes.length] = this.reduceTagByte;
                    }
                    this.keyWritable.setDistKeyLength(this.nullBytes.length);
                    this.keyWritable.setHashCode(this.nullKeyHashCode);
                } else {
                    int keyLength = this.serializedKeySeries.getSerializedLength();
                    if (tag == -1 || this.reduceSkipTag) {
                        this.keyWritable.set(this.serializedKeySeries.getSerializedBytes(), this.serializedKeySeries.getSerializedStart(), keyLength);
                    } else {
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(this.serializedKeySeries.getSerializedBytes(), this.serializedKeySeries.getSerializedStart(), this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.reduceTagByte;
                    }
                    this.keyWritable.setDistKeyLength(keyLength);
                    this.keyWritable.setHashCode(this.serializedKeySeries.getCurrentHashCode());
                }
                int logical = this.serializedKeySeries.getCurrentLogical();
                int end = logical + this.serializedKeySeries.getCurrentDuplicateCount();
                do {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    this.valueLazyBinarySerializeWrite.reset();
                    this.valueVectorSerializeRow.serializeWrite(batch, batchIndex);
                    this.valueBytesWritable.set(this.valueOutput.getData(), 0, this.valueOutput.getLength());
                    this.collect(this.keyWritable, (Writable)this.valueBytesWritable);
                } while (++logical < end);
            } while (this.serializedKeySeries.next());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    protected void collect(BytesWritable keyWritable, Writable valueWritable) throws IOException {
        if (null != this.out) {
            ++this.numRows;
            if (this.isLogInfoEnabled && this.numRows == this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 0L;
                    this.numRows = 1L;
                }
                LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
            }
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        this.out = null;
        if (this.isLogInfoEnabled) {
            LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
        }
        this.recordCounter.set(this.numRows);
    }

    @Override
    public String getName() {
        return VectorReduceSinkCommonOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public boolean getIsReduceSink() {
        return true;
    }

    @Override
    public String getReduceOutputName() {
        return ((ReduceSinkDesc)this.conf).getOutputName();
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }
}

