/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PriorityBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private final int capacity;
    private final LinkedList<E> list;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private Comparator<E> comparator;

    public PriorityBlockingDeque() {
        this(null, Integer.MAX_VALUE);
    }

    public PriorityBlockingDeque(int capacity) {
        this(null, capacity);
    }

    public PriorityBlockingDeque(Comparator<E> comparator) {
        this(comparator, Integer.MAX_VALUE);
    }

    public PriorityBlockingDeque(Comparator<E> comparator, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.list = new LinkedList();
        this.comparator = comparator;
    }

    private boolean innerAdd(E e) {
        if (this.list.size() >= this.capacity) {
            return false;
        }
        int insertionPoint = Collections.binarySearch(this.list, e, this.comparator);
        if (insertionPoint < 0) {
            insertionPoint = -insertionPoint - 1;
        }
        this.list.add(insertionPoint, e);
        this.notEmpty.signal();
        return true;
    }

    private E innerRemoveFirst() {
        E f = this.list.pollFirst();
        if (f == null) {
            return null;
        }
        this.notFull.signal();
        return f;
    }

    private E innerRemoveLast() {
        E l = this.list.pollLast();
        if (l == null) {
            return null;
        }
        this.notFull.signal();
        return l;
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.innerAdd(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.innerAdd(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putFirst(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.innerAdd(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.innerAdd(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.innerAdd(e)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.innerAdd(e)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        this.lock.lock();
        try {
            E e = this.innerRemoveFirst();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E pollLast() {
        this.lock.lock();
        try {
            E e = this.innerRemoveLast();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            E x;
            while ((x = this.innerRemoveFirst()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            E x;
            while ((x = this.innerRemoveLast()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                E x;
                if ((x = this.innerRemoveFirst()) != null) {
                    E e = x;
                    return e;
                }
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                E x;
                if ((x = this.innerRemoveLast()) != null) {
                    E e = x;
                    return e;
                }
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E peekFirst() {
        this.lock.lock();
        try {
            E e = this.list.size() == 0 ? null : (E)this.list.peekFirst();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peekLast() {
        this.lock.lock();
        try {
            E e = this.list.size() == 0 ? null : (E)this.list.peekLast();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Object e = it.next();
                if (!o.equals(e)) continue;
                it.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Iterator<E> it = this.list.descendingIterator();
            while (it.hasNext()) {
                E e = it.next();
                if (!o.equals(e)) continue;
                it.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            for (Object e : this.list) {
                c.add(e);
            }
            int n = this.list.size();
            this.list.clear();
            this.notFull.signalAll();
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n;
            Iterator it = this.list.iterator();
            for (n = 0; n < maxElements && it.hasNext(); ++n) {
                Object e = it.next();
                c.add(e);
                it.remove();
            }
            this.notFull.signalAll();
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.list.clear();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.list.descendingIterator();
    }
}

