/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import com.sforce.ws.MessageHandlerWithHeaders;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.LimitingInputStream;
import com.sforce.ws.transport.LimitingOutputStream;
import com.sforce.ws.transport.MessageHandlerOutputStream;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.Base64;
import com.sforce.ws.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JdkHttpTransport
implements Transport {
    private HttpURLConnection connection;
    private boolean successful;
    private ConnectorConfig config;
    private URL url;

    public JdkHttpTransport() {
    }

    public JdkHttpTransport(ConnectorConfig config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    @Override
    public OutputStream connect(String uri, HashMap<String, String> httpHeaders) throws IOException {
        return this.connectLocal(uri, httpHeaders, true);
    }

    @Override
    public OutputStream connect(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.connectLocal(uri, httpHeaders, enableCompression);
    }

    @Override
    public OutputStream connect(String uri, String soapAction) throws IOException {
        if (soapAction == null) {
            soapAction = "";
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("SOAPAction", "\"" + soapAction + "\"");
        header.put("Content-Type", "text/xml; charset=UTF-8");
        header.put("Accept", "text/xml");
        return this.connectLocal(uri, header);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders) throws IOException {
        return this.connectLocal(uri, httpHeaders, true);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.wrapOutput(this.connectRaw(uri, httpHeaders, enableCompression), enableCompression);
    }

    private OutputStream wrapOutput(OutputStream output, boolean enableCompression) throws IOException {
        if (this.config.getMaxRequestSize() > 0) {
            output = new LimitingOutputStream(this.config.getMaxRequestSize(), output);
        }
        if (enableCompression && this.config.isCompression()) {
            output = new GZIPOutputStream(output);
        }
        if (this.config.isTraceMessage()) {
            output = this.config.teeOutputStream(output);
        }
        if (this.config.hasMessageHandlers()) {
            output = new MessageHandlerOutputStream(this.config, this.url, output);
        }
        return output;
    }

    private OutputStream connectRaw(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        this.url = new URL(uri);
        this.connection = JdkHttpTransport.createConnection(this.config, this.url, httpHeaders, enableCompression);
        this.connection.setRequestMethod("POST");
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        if (this.config.useChunkedPost()) {
            this.connection.setChunkedStreamingMode(4096);
        }
        return this.connection.getOutputStream();
    }

    public static HttpURLConnection createConnection(ConnectorConfig config, URL url, HashMap<String, String> httpHeaders) throws IOException {
        return JdkHttpTransport.createConnection(config, url, httpHeaders, true);
    }

    public static HttpURLConnection createConnection(ConnectorConfig config, URL url, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        if (config.isTraceMessage()) {
            config.getTraceStream().println("WSC: Creating a new connection to " + url + " Proxy = " + config.getProxy() + " username " + config.getProxyUsername());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(config.getProxy());
        if (httpHeaders == null || httpHeaders.get("User-Agent") == null && httpHeaders.get("user-agent") == null) {
            connection.addRequestProperty("User-Agent", VersionInfo.info());
        }
        if (config.getHeaders() != null) {
            for (Map.Entry<String, String> ent : config.getHeaders().entrySet()) {
                connection.setRequestProperty(ent.getKey(), ent.getValue());
            }
        }
        if (enableCompression && config.isCompression()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (config.getProxyUsername() != null) {
            String token = config.getProxyUsername() + ":" + config.getProxyPassword();
            String auth = "Basic " + new String(Base64.encode(token.getBytes()));
            connection.addRequestProperty("Proxy-Authorization", auth);
            connection.addRequestProperty("Https-Proxy-Authorization", auth);
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (config.getReadTimeout() != 0) {
            connection.setReadTimeout(config.getReadTimeout());
        }
        if (config.getConnectionTimeout() != 0) {
            connection.setConnectTimeout(config.getConnectionTimeout());
        }
        if (config.isTraceMessage()) {
            config.getTraceStream().println("WSC: Connection configured to have request properties " + connection.getRequestProperties());
        }
        return connection;
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream in;
        block10: {
            try {
                in = this.connection.getInputStream();
            }
            catch (IOException e) {
                in = this.connection.getErrorStream();
                if (in != null) break block10;
                throw e;
            }
        }
        this.successful = this.connection.getResponseCode() < 400;
        String encoding = this.connection.getHeaderField("Content-Encoding");
        if (this.config.getMaxResponseSize() > 0) {
            in = new LimitingInputStream(this.config.getMaxResponseSize(), in);
        }
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        }
        if (this.config.hasMessageHandlers() || this.config.isTraceMessage()) {
            byte[] bytes = FileUtil.toBytes(in);
            in = new ByteArrayInputStream(bytes);
            if (this.config.hasMessageHandlers()) {
                Iterator<MessageHandler> it = this.config.getMessagerHandlers();
                while (it.hasNext()) {
                    MessageHandler handler = it.next();
                    if (handler instanceof MessageHandlerWithHeaders) {
                        ((MessageHandlerWithHeaders)handler).handleResponse(this.url, bytes, this.connection.getHeaderFields());
                        continue;
                    }
                    handler.handleResponse(this.url, bytes);
                }
            }
            if (this.config.isTraceMessage()) {
                Map<String, List<String>> headers = this.connection.getHeaderFields();
                for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                    this.config.getTraceStream().print((Object)header.getKey());
                    this.config.getTraceStream().print("=");
                    this.config.getTraceStream().println(header.getValue());
                }
                this.config.teeInputStream(bytes);
            }
        }
        return in;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }
}

