/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.metastore.api.IMetaStore;

public interface StepInterface
extends VariableSpace,
HasLogChannelInterface {
    public Trans getTrans();

    public boolean processRow(StepMetaInterface var1, StepDataInterface var2) throws KettleException;

    public boolean canProcessOneRow();

    public boolean init(StepMetaInterface var1, StepDataInterface var2);

    public void dispose(StepMetaInterface var1, StepDataInterface var2);

    public void markStart();

    public void markStop();

    public void stopRunning(StepMetaInterface var1, StepDataInterface var2) throws KettleException;

    public boolean isRunning();

    public void setRunning(boolean var1);

    public boolean isStopped();

    public void setStopped(boolean var1);

    default public void setSafeStopped(boolean stopped) {
    }

    default public boolean isSafeStopped() {
        return false;
    }

    public boolean isPaused();

    public void stopAll();

    public void pauseRunning();

    public void resumeRunning();

    public String getStepname();

    public int getCopy();

    public String getStepID();

    public long getErrors();

    public void setErrors(long var1);

    public long getLinesInput();

    public long getLinesOutput();

    public long getLinesRead();

    public long getLinesWritten();

    public long getLinesUpdated();

    public void setLinesRejected(long var1);

    public long getLinesRejected();

    public void putRow(RowMetaInterface var1, Object[] var2) throws KettleException;

    public Object[] getRow() throws KettleException;

    public void setOutputDone();

    public void addRowListener(RowListener var1);

    public void removeRowListener(RowListener var1);

    public List<RowListener> getRowListeners();

    public List<RowSet> getInputRowSets();

    public List<RowSet> getOutputRowSets();

    public boolean isPartitioned();

    public void setPartitionID(String var1);

    public String getPartitionID();

    public void cleanup();

    public void initBeforeStart() throws KettleStepException;

    public void addStepListener(StepListener var1);

    public boolean isMapping();

    public StepMeta getStepMeta();

    @Override
    public LogChannelInterface getLogChannel();

    public void setUsingThreadPriorityManagment(boolean var1);

    public boolean isUsingThreadPriorityManagment();

    public int rowsetInputSize();

    public int rowsetOutputSize();

    public long getProcessed();

    public Map<String, ResultFile> getResultFiles();

    public BaseStepData.StepExecutionStatus getStatus();

    public long getRuntime();

    public void identifyErrorOutput();

    public void setPartitioned(boolean var1);

    public void setRepartitioning(int var1);

    public void batchComplete() throws KettleException;

    public void setMetaStore(IMetaStore var1);

    public IMetaStore getMetaStore();

    public void setRepository(Repository var1);

    public Repository getRepository();

    public int getCurrentOutputRowSetNr();

    public void setCurrentOutputRowSetNr(int var1);

    public int getCurrentInputRowSetNr();

    public void setCurrentInputRowSetNr(int var1);

    default public Collection<StepStatus> subStatuses() {
        return Collections.emptyList();
    }

    default public void addRowSetToInputRowSets(RowSet rowSet) {
        this.getInputRowSets().add(rowSet);
    }

    default public void addRowSetToOutputRowSets(RowSet rowSet) {
        this.getOutputRowSets().add(rowSet);
    }
}

