/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tablecompare;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tablecompare.Kjube;
import org.pentaho.di.trans.steps.tablecompare.TableCompareData;
import org.pentaho.di.trans.steps.tablecompare.TableCompareMeta;

public class TableCompare
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TableCompare.class;
    private TableCompareMeta meta = (TableCompareMeta)this.getStepMeta().getStepMetaInterface();
    private TableCompareData data;

    public TableCompare(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (TableCompareData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TableCompareMeta)smi;
        this.data = (TableCompareData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (Utils.isEmpty((CharSequence)this.meta.getReferenceSchemaField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ReferenceSchemaNotSpecified", (String[])new String[0]));
            }
            this.data.refSchemaIndex = this.getInputRowMeta().indexOfValue(this.meta.getReferenceSchemaField());
            if (this.data.refSchemaIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getReferenceSchemaField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getReferenceTableField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ReferenceTableNotSpecified", (String[])new String[0]));
            }
            this.data.refTableIndex = this.getInputRowMeta().indexOfValue(this.meta.getReferenceTableField());
            if (this.data.refTableIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getReferenceTableField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getCompareSchemaField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CompareSchemaNotSpecified", (String[])new String[0]));
            }
            this.data.cmpSchemaIndex = this.getInputRowMeta().indexOfValue(this.meta.getCompareSchemaField());
            if (this.data.cmpSchemaIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getCompareSchemaField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getCompareTableField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CompareTableNotSpecified", (String[])new String[0]));
            }
            this.data.cmpTableIndex = this.getInputRowMeta().indexOfValue(this.meta.getCompareTableField());
            if (this.data.cmpTableIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getCompareTableField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getKeyFieldsField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.KeyFieldsNotSpecified", (String[])new String[0]));
            }
            this.data.keyFieldsIndex = this.getInputRowMeta().indexOfValue(this.meta.getKeyFieldsField());
            if (this.data.keyFieldsIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getKeyFieldsField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getExcludeFieldsField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ExcludeFieldsNotSpecified", (String[])new String[0]));
            }
            this.data.excludeFieldsIndex = this.getInputRowMeta().indexOfValue(this.meta.getExcludeFieldsField());
            if (this.data.excludeFieldsIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getExcludeFieldsField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getKeyDescriptionField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.KeyDescriptionFieldNotSpecified", (String[])new String[0]));
            }
            this.data.keyDescIndex = this.getInputRowMeta().indexOfValue(this.meta.getKeyDescriptionField());
            if (this.data.keyDescIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getKeyDescriptionField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getValueReferenceField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ValueReferenceFieldNotSpecified", (String[])new String[0]));
            }
            this.data.valueReferenceIndex = this.getInputRowMeta().indexOfValue(this.meta.getValueReferenceField());
            if (this.data.valueReferenceIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getValueReferenceField()}));
            }
            if (Utils.isEmpty((CharSequence)this.meta.getValueCompareField())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ValueCompareFieldNotSpecified", (String[])new String[0]));
            }
            this.data.valueCompareIndex = this.getInputRowMeta().indexOfValue(this.meta.getValueCompareField());
            if (this.data.valueCompareIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CanNotFindField", (String[])new String[]{this.meta.getValueCompareField()}));
            }
        }
        Object[] fields = this.compareTables(this.getInputRowMeta(), r);
        Object[] outputRowData = RowDataUtil.addRowData((Object[])r, (int)this.getInputRowMeta().size(), (Object[])fields);
        this.putRow(this.data.outputRowMeta, outputRowData);
        return true;
    }

    private Object[] compareTables(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            String referenceSchema = this.getInputRowMeta().getString(r, this.data.refSchemaIndex);
            String referenceTable = this.getInputRowMeta().getString(r, this.data.refTableIndex);
            String compareSchema = this.getInputRowMeta().getString(r, this.data.cmpSchemaIndex);
            String compareTable = this.getInputRowMeta().getString(r, this.data.cmpTableIndex);
            String keyFields = this.getInputRowMeta().getString(r, this.data.keyFieldsIndex);
            String excludeFields = this.getInputRowMeta().getString(r, this.data.excludeFieldsIndex);
            return this.compareTables(rowMeta, r, referenceSchema, referenceTable, compareSchema, compareTable, keyFields, excludeFields);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorComparingTables", (String[])new String[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] compareTables(RowMetaInterface rowMeta, Object[] r, String referenceSchema, String referenceTable, String compareSchema, String compareTable, String keyFields, String excludeFields) throws KettleException {
        Object[] errorRowData;
        long nrErrors = 0L;
        long nrLeftErrors = 0L;
        long nrRightErrors = 0L;
        long nrInnerErrors = 0L;
        long nrRecordsReference = 0L;
        long nrRecordsCompare = 0L;
        Object[] result = new Object[6];
        if (Utils.isEmpty((CharSequence)referenceTable)) {
            errorRowData = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(this.data.errorRowMeta, errorRowData, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoReferenceTableDefined", (String[])new String[0]), null, "TAC008");
            ++nrErrors;
        }
        if (Utils.isEmpty((CharSequence)compareTable)) {
            errorRowData = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(this.data.errorRowMeta, errorRowData, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoCompareTableDefined", (String[])new String[0]), null, "TAC008");
            ++nrErrors;
        }
        String refSchemaTable = this.meta.getReferenceConnection().getQuotedSchemaTableCombination(referenceSchema, referenceTable);
        String cmpSchemaTable = this.meta.getCompareConnection().getQuotedSchemaTableCombination(compareSchema, compareTable);
        if (Utils.isEmpty((CharSequence)keyFields)) {
            Object[] errorRowData2 = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(this.data.errorRowMeta, errorRowData2, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoKeyFieldsDefined", (String[])new String[]{refSchemaTable, cmpSchemaTable}), null, "TAC007");
            ++nrErrors;
        }
        if (nrErrors > 0L) {
            result[0] = nrErrors;
            return result;
        }
        String[] keys = keyFields.split(",");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Kjube.trim(keys[i]);
        }
        String[] excluded = Utils.isEmpty((CharSequence)excludeFields) ? new String[]{} : excludeFields.split(",");
        for (int i = 0; i < excluded.length; ++i) {
            excluded[i] = Kjube.trim(excluded[i]);
        }
        try {
            RowMetaInterface refFields = this.data.referenceDb.getTableFieldsMeta(referenceSchema, referenceTable);
            RowMetaInterface cmpFields = this.data.compareDb.getTableFieldsMeta(referenceSchema, referenceTable);
            for (String string : excluded) {
                if (refFields.indexOfValue(string) >= 0) {
                    refFields.removeValueMeta(string);
                }
                if (cmpFields.indexOfValue(string) < 0) continue;
                cmpFields.removeValueMeta(string);
            }
            if (refFields.size() != cmpFields.size()) {
                Object[] errorRowData3 = this.constructErrorRow(rowMeta, r, null, null, null);
                this.putError(this.data.errorRowMeta, errorRowData3, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.NumberOfFieldsIsDifferent", (String[])new String[]{refSchemaTable, Integer.toString(refFields.size()), cmpSchemaTable, Integer.toString(cmpFields.size())}), null, "TAC001");
                ++nrErrors;
            } else {
                Object[] two;
                void var31_44;
                void var31_41;
                for (String string : keys) {
                    if (refFields.indexOfValue(string) >= 0) continue;
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        Object[] errorRowData4 = this.constructErrorRow(rowMeta, r, null, null, null);
                        this.putError(this.data.errorRowMeta, errorRowData4, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.KeyFieldWasNotFoundInReferenceTable", (String[])new String[]{string, refSchemaTable}), null, "TAC002");
                    }
                    ++nrErrors;
                }
                for (String string : keys) {
                    if (cmpFields.indexOfValue(string) >= 0) continue;
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        Object[] errorRowData2 = this.constructErrorRow(rowMeta, r, null, null, null);
                        this.putError(this.data.errorRowMeta, errorRowData2, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.KeyFieldWasNotFoundInCompareTable", (String[])new String[]{string, refSchemaTable}), null, "TAC003");
                    }
                    ++nrErrors;
                }
                if (nrErrors > 0L) {
                    result[0] = nrErrors;
                    return result;
                }
                RowMeta keyRowMeta = new RowMeta();
                RowMeta valueRowMeta = new RowMeta();
                int[] keyNrs = new int[keys.length];
                String string = "SELECT ";
                String cmpSql = "SELECT ";
                for (int i = 0; i < keys.length; ++i) {
                    void var31_39;
                    if (i > 0) {
                        void var31_37;
                        String string2 = (String)var31_37 + ", ";
                        cmpSql = cmpSql + ", ";
                    }
                    keyNrs[i] = i;
                    String string3 = (String)var31_39 + this.meta.getReferenceConnection().quoteField(keys[i]);
                    cmpSql = cmpSql + this.meta.getReferenceConnection().quoteField(keys[i]);
                }
                int[] valueNrs = new int[refFields.size() - keys.length];
                int valueNr = keys.length;
                int valueIndex = 0;
                for (int i = 0; i < refFields.getFieldNames().length; ++i) {
                    String field = refFields.getFieldNames()[i];
                    if (Const.indexOfString((String)field, (String[])keys) >= 0) continue;
                    String string4 = (String)var31_41 + ", " + this.meta.getReferenceConnection().quoteField(field);
                    valueRowMeta.addValueMeta(refFields.searchValueMeta(field));
                    valueNrs[valueIndex++] = valueNr++;
                }
                for (String field : cmpFields.getFieldNames()) {
                    if (Const.indexOfString((String)field, (String[])keys) >= 0) continue;
                    cmpSql = cmpSql + ", " + this.meta.getCompareConnection().quoteField(field);
                }
                String string5 = (String)var31_41 + " FROM " + refSchemaTable + " ORDER BY ";
                cmpSql = cmpSql + " FROM " + cmpSchemaTable + " ORDER BY ";
                for (int i = 0; i < keys.length; ++i) {
                    void var31_46;
                    if (i > 0) {
                        String string6 = (String)var31_44 + ", ";
                        cmpSql = cmpSql + ", ";
                    }
                    String string7 = (String)var31_46 + this.meta.getReferenceConnection().quoteField(keys[i]);
                    cmpSql = cmpSql + this.meta.getReferenceConnection().quoteField(keys[i]);
                }
                ResultSet refSet = this.data.referenceDb.openQuery((String)var31_44);
                ResultSet cmpSet = this.data.compareDb.openQuery(cmpSql);
                RowMetaInterface oneMeta = null;
                RowMetaInterface twoMeta = null;
                Object[] one = this.data.referenceDb.getRow(refSet);
                if (one != null) {
                    this.incrementLinesInput();
                    if (oneMeta == null) {
                        oneMeta = this.data.referenceDb.getReturnRowMeta();
                        for (int i = 0; i < keys.length; ++i) {
                            keyRowMeta.addValueMeta(oneMeta.searchValueMeta(keys[i]));
                        }
                    }
                }
                if ((two = this.data.compareDb.getRow(cmpSet)) != null) {
                    this.incrementLinesInput();
                    if (twoMeta == null) {
                        twoMeta = this.data.compareDb.getReturnRowMeta();
                        if (keyRowMeta.isEmpty()) {
                            for (int i = 0; i < keys.length; ++i) {
                                keyRowMeta.addValueMeta(twoMeta.searchValueMeta(keys[i]));
                            }
                        }
                    }
                }
                if (one != null) {
                    ++nrRecordsReference;
                }
                if (two != null) {
                    ++nrRecordsCompare;
                }
                do {
                    if (one == null && two != null) {
                        if (this.getStepMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((RowMetaInterface)keyRowMeta, keyNrs, two);
                            Object[] errorRowData6 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(this.data.errorRowMeta, errorRowData6, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordNotInReferenceFoundInCompareTable", (String[])new String[]{cmpSchemaTable, keyRowMeta.getString(two)}), null, "TAC004");
                        }
                        ++nrErrors;
                        ++nrRightErrors;
                        two = this.data.compareDb.getRow(cmpSet);
                        if (two == null) continue;
                        ++nrRecordsCompare;
                        continue;
                    }
                    if (one != null && two == null) {
                        if (this.getStepMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((RowMetaInterface)keyRowMeta, keyNrs, one);
                            Object[] errorRowData7 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(this.data.errorRowMeta, errorRowData7, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordInReferenceNotFoundInCompareTable", (String[])new String[]{refSchemaTable, keyRowMeta.getString(one)}), null, "TAC005");
                        }
                        ++nrErrors;
                        ++nrLeftErrors;
                        one = this.data.referenceDb.getRow(refSet);
                        if (one == null) continue;
                        ++nrRecordsReference;
                        continue;
                    }
                    if (one == null || two == null) continue;
                    int compare = oneMeta.compare(one, two, keyNrs);
                    if (compare == 0) {
                        int compareValues = oneMeta.compare(one, two, valueNrs);
                        if (compareValues != 0) {
                            if (this.getStepMeta().isDoingErrorHandling()) {
                                for (int idx : valueNrs) {
                                    Object twoData;
                                    Object oneData;
                                    ValueMetaInterface valueMeta = oneMeta.getValueMeta(idx);
                                    int cmp = valueMeta.compare(oneData = one[idx], twoData = two[idx]);
                                    if (cmp == 0) continue;
                                    String keyDesc = this.getKeyDesc((RowMetaInterface)keyRowMeta, keyNrs, one);
                                    String quote = valueMeta.isString() ? "'" : "";
                                    String referenceData = quote + valueMeta.getString(oneData) + quote;
                                    String compareData = quote + valueMeta.getString(twoData) + quote;
                                    Object[] errorRowData8 = this.constructErrorRow(rowMeta, r, keyDesc, referenceData, compareData);
                                    this.putError(this.data.errorRowMeta, errorRowData8, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.CompareRowIsDifferentFromReference", (String[])new String[0]), valueMeta.getName(), "TAC006");
                                }
                            }
                            ++nrErrors;
                            ++nrInnerErrors;
                        }
                        if ((one = this.data.referenceDb.getRow(refSet)) != null) {
                            ++nrRecordsReference;
                        }
                        if ((two = this.data.compareDb.getRow(cmpSet)) == null) continue;
                        ++nrRecordsCompare;
                        continue;
                    }
                    if (compare < 0) {
                        if (this.getStepMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((RowMetaInterface)keyRowMeta, keyNrs, one);
                            Object[] errorRowData5 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(this.data.errorRowMeta, errorRowData5, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordNotInReferenceFoundInCompareTable", (String[])new String[]{cmpSchemaTable, keyRowMeta.getString(one)}), null, "TAC004");
                        }
                        ++nrErrors;
                        ++nrRightErrors;
                        one = this.data.referenceDb.getRow(refSet);
                        if (one == null) continue;
                        ++nrRecordsReference;
                        continue;
                    }
                    if (this.getStepMeta().isDoingErrorHandling()) {
                        String keyDesc = this.getKeyDesc((RowMetaInterface)keyRowMeta, keyNrs, two);
                        Object[] errorRowData3 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                        this.putError(this.data.errorRowMeta, errorRowData3, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordInReferenceNotFoundInCompareTable", (String[])new String[]{refSchemaTable, keyRowMeta.getString(two)}), null, "TAC005");
                    }
                    ++nrErrors;
                    ++nrLeftErrors;
                    two = this.data.compareDb.getRow(cmpSet);
                    if (two == null) continue;
                    ++nrRecordsCompare;
                } while ((one != null || two != null) && !this.isStopped());
                refSet.close();
                cmpSet.close();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorComparingTables", (String[])new String[]{refSchemaTable, cmpSchemaTable}), (Throwable)e);
        }
        int index = 0;
        result[index++] = nrErrors;
        result[index++] = nrRecordsReference;
        result[index++] = nrRecordsCompare;
        result[index++] = nrLeftErrors;
        result[index++] = nrInnerErrors;
        result[index++] = nrRightErrors;
        r[this.data.keyDescIndex] = null;
        r[this.data.valueReferenceIndex] = null;
        r[this.data.valueCompareIndex] = null;
        return result;
    }

    private String getKeyDesc(RowMetaInterface keyRowMeta, int[] keyNrs, Object[] one) throws KettleException {
        StringBuilder keyDesc = new StringBuilder();
        for (int x = 0; x < keyNrs.length; ++x) {
            ValueMetaInterface keyValueMeta = keyRowMeta.getValueMeta(x);
            Object keyValueData = one[keyNrs[x]];
            if (keyDesc.length() > 0) {
                keyDesc.append(" and ");
            }
            keyDesc.append(keyValueMeta.getName()).append(" = '");
            keyDesc.append(keyValueMeta.getString(keyValueData));
            keyDesc.append("'");
        }
        return keyDesc.toString();
    }

    private Object[] constructErrorRow(RowMetaInterface rowMeta, Object[] r, String keyField, String referenceValue, String compareValue) throws KettleException {
        if (this.data.errorRowMeta == null) {
            this.data.errorRowMeta = rowMeta.clone();
        }
        r[this.data.keyDescIndex] = keyField;
        r[this.data.valueReferenceIndex] = referenceValue;
        r[this.data.valueCompareIndex] = compareValue;
        return r;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableCompareMeta)smi;
        this.data = (TableCompareData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.referenceDb = new Database((LoggingObjectInterface)this, this.meta.getReferenceConnection());
                this.data.referenceDb.connect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorConnectingToReferenceDatabase", (String[])new String[]{this.meta.getReferenceConnection().getName()}), e);
                return false;
            }
            try {
                this.data.compareDb = new Database((LoggingObjectInterface)this, this.meta.getCompareConnection());
                this.data.compareDb.connect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorConnectingToCompareDatabase", (String[])new String[]{this.meta.getCompareConnection().getName()}), e);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TableCompareMeta)smi;
        this.data = (TableCompareData)sdi;
        if (this.data.referenceDb != null) {
            this.data.referenceDb.disconnect();
        }
        if (this.data.compareDb != null) {
            this.data.compareDb.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

