/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServerStatus {
    public static final String XML_TAG = "serverstatus";
    private String statusDescription;
    private String errorDescription;
    private List<SlaveServerTransStatus> transStatusList;
    private List<SlaveServerJobStatus> jobStatusList;
    private long memoryFree;
    private long memoryTotal;
    private int cpuCores;
    private long cpuProcessTime;
    private long uptime;
    private int threadCount;
    private double loadAvg;
    private String osName;
    private String osVersion;
    private String osArchitecture;

    public SlaveServerStatus() {
        this.transStatusList = new ArrayList<SlaveServerTransStatus>();
        this.jobStatusList = new ArrayList<SlaveServerJobStatus>();
    }

    public SlaveServerStatus(String statusDescription) {
        this();
        this.statusDescription = statusDescription;
    }

    public SlaveServerStatus(String statusDescription, List<SlaveServerTransStatus> transStatusList, List<SlaveServerJobStatus> jobStatusList) {
        this.statusDescription = statusDescription;
        this.transStatusList = transStatusList;
        this.jobStatusList = jobStatusList;
    }

    public String getXML() throws KettleException {
        int i;
        StringBuilder xml = new StringBuilder();
        xml.append("<serverstatus>").append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"statusdesc", (String)this.statusDescription));
        xml.append(XMLHandler.addTagValue((String)"memory_free", (long)this.memoryFree));
        xml.append(XMLHandler.addTagValue((String)"memory_total", (long)this.memoryTotal));
        xml.append(XMLHandler.addTagValue((String)"cpu_cores", (int)this.cpuCores));
        xml.append(XMLHandler.addTagValue((String)"cpu_process_time", (long)this.cpuProcessTime));
        xml.append(XMLHandler.addTagValue((String)"uptime", (long)this.uptime));
        xml.append(XMLHandler.addTagValue((String)"thread_count", (int)this.threadCount));
        xml.append(XMLHandler.addTagValue((String)"load_avg", (double)this.loadAvg));
        xml.append(XMLHandler.addTagValue((String)"os_name", (String)this.osName));
        xml.append(XMLHandler.addTagValue((String)"os_version", (String)this.osVersion));
        xml.append(XMLHandler.addTagValue((String)"os_arch", (String)this.osArchitecture));
        xml.append("  <transstatuslist>").append(Const.CR);
        for (i = 0; i < this.transStatusList.size(); ++i) {
            SlaveServerTransStatus transStatus = this.transStatusList.get(i);
            xml.append("    ").append(transStatus.getXML()).append(Const.CR);
        }
        xml.append("  </transstatuslist>").append(Const.CR);
        xml.append("  <jobstatuslist>").append(Const.CR);
        for (i = 0; i < this.jobStatusList.size(); ++i) {
            SlaveServerJobStatus jobStatus = this.jobStatusList.get(i);
            xml.append("    ").append(jobStatus.getXML()).append(Const.CR);
        }
        xml.append("  </jobstatuslist>").append(Const.CR);
        xml.append("</serverstatus>").append(Const.CR);
        return xml.toString();
    }

    public SlaveServerStatus(Node statusNode) throws KettleException {
        this();
        int i;
        this.statusDescription = XMLHandler.getTagValue((Node)statusNode, (String)"statusdesc");
        this.memoryFree = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"memory_free"), (long)-1L);
        this.memoryTotal = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"memory_total"), (long)-1L);
        String cpuCoresStr = XMLHandler.getTagValue((Node)statusNode, (String)"cpu_cores");
        this.cpuCores = Const.toInt((String)cpuCoresStr, (int)-1);
        String cpuProcessTimeStr = XMLHandler.getTagValue((Node)statusNode, (String)"cpu_process_time");
        this.cpuProcessTime = Utils.isEmpty((CharSequence)cpuProcessTimeStr) ? 0L : Long.valueOf(cpuProcessTimeStr);
        this.uptime = Const.toLong((String)XMLHandler.getTagValue((Node)statusNode, (String)"uptime"), (long)-1L);
        this.threadCount = Const.toInt((String)XMLHandler.getTagValue((Node)statusNode, (String)"thread_count"), (int)-1);
        this.loadAvg = Const.toDouble((String)XMLHandler.getTagValue((Node)statusNode, (String)"load_avg"), (double)-1.0);
        this.osName = XMLHandler.getTagValue((Node)statusNode, (String)"os_name");
        this.osVersion = XMLHandler.getTagValue((Node)statusNode, (String)"os_version");
        this.osArchitecture = XMLHandler.getTagValue((Node)statusNode, (String)"os_arch");
        Node listTransNode = XMLHandler.getSubNode((Node)statusNode, (String)"transstatuslist");
        Node listJobsNode = XMLHandler.getSubNode((Node)statusNode, (String)"jobstatuslist");
        int nrTrans = XMLHandler.countNodes((Node)listTransNode, (String)"transstatus");
        int nrJobs = XMLHandler.countNodes((Node)listJobsNode, (String)"jobstatus");
        for (i = 0; i < nrTrans; ++i) {
            Node transStatusNode = XMLHandler.getSubNodeByNr((Node)listTransNode, (String)"transstatus", (int)i);
            this.transStatusList.add(new SlaveServerTransStatus(transStatusNode));
        }
        for (i = 0; i < nrJobs; ++i) {
            Node jobStatusNode = XMLHandler.getSubNodeByNr((Node)listJobsNode, (String)"jobstatus", (int)i);
            this.jobStatusList.add(new SlaveServerJobStatus(jobStatusNode));
        }
    }

    public static SlaveServerStatus fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        return new SlaveServerStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public List<SlaveServerTransStatus> getTransStatusList() {
        return this.transStatusList;
    }

    public void setTransStatusList(List<SlaveServerTransStatus> transStatusList) {
        this.transStatusList = transStatusList;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public SlaveServerTransStatus findTransStatus(String transName, String id) {
        for (int i = 0; i < this.transStatusList.size(); ++i) {
            SlaveServerTransStatus transStatus = this.transStatusList.get(i);
            if (!transStatus.getTransName().equalsIgnoreCase(transName) || !Utils.isEmpty((CharSequence)id) && !transStatus.getId().equals(id)) continue;
            return transStatus;
        }
        return null;
    }

    public SlaveServerJobStatus findJobStatus(String jobName, String id) {
        for (int i = 0; i < this.jobStatusList.size(); ++i) {
            SlaveServerJobStatus jobStatus = this.jobStatusList.get(i);
            if (!jobStatus.getJobName().equalsIgnoreCase(jobName) || !Utils.isEmpty((CharSequence)id) && !jobStatus.getId().equals(id)) continue;
            return jobStatus;
        }
        return null;
    }

    public List<SlaveServerJobStatus> getJobStatusList() {
        return this.jobStatusList;
    }

    public void setJobStatusList(List<SlaveServerJobStatus> jobStatusList) {
        this.jobStatusList = jobStatusList;
    }

    public double getMemoryFree() {
        return this.memoryFree;
    }

    public void setMemoryFree(long memoryFree) {
        this.memoryFree = memoryFree;
    }

    public double getMemoryTotal() {
        return this.memoryTotal;
    }

    public void setMemoryTotal(long memoryTotal) {
        this.memoryTotal = memoryTotal;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public long getCpuProcessTime() {
        return this.cpuProcessTime;
    }

    public void setCpuProcessTime(long cpuProcessTime) {
        this.cpuProcessTime = cpuProcessTime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setLoadAvg(double loadAvg) {
        this.loadAvg = loadAvg;
    }

    public double getLoadAvg() {
        return this.loadAvg;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsArchitecture(String osArch) {
        this.osArchitecture = osArch;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }
}

