/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.jobhistory.AMStarted;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMStartedEvent
implements HistoryEvent {
    private AMStarted datum = new AMStarted();
    private String forcedJobStateOnShutDown;
    private long submitTime;

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort, long submitTime) {
        this(appAttemptId, startTime, containerId, nodeManagerHost, nodeManagerPort, nodeManagerHttpPort, null, submitTime);
    }

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort, String forcedJobStateOnShutDown, long submitTime) {
        this.datum.applicationAttemptId = new Utf8(appAttemptId.toString());
        this.datum.startTime = startTime;
        this.datum.containerId = new Utf8(containerId.toString());
        this.datum.nodeManagerHost = new Utf8(nodeManagerHost);
        this.datum.nodeManagerPort = nodeManagerPort;
        this.datum.nodeManagerHttpPort = nodeManagerHttpPort;
        this.forcedJobStateOnShutDown = forcedJobStateOnShutDown;
        this.submitTime = submitTime;
    }

    AMStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (AMStarted)((Object)datum);
    }

    public ApplicationAttemptId getAppAttemptId() {
        return ConverterUtils.toApplicationAttemptId((String)this.datum.applicationAttemptId.toString());
    }

    public long getStartTime() {
        return this.datum.startTime;
    }

    public ContainerId getContainerId() {
        return ConverterUtils.toContainerId((String)this.datum.containerId.toString());
    }

    public String getNodeManagerHost() {
        return this.datum.nodeManagerHost.toString();
    }

    public int getNodeManagerPort() {
        return this.datum.nodeManagerPort;
    }

    public int getNodeManagerHttpPort() {
        return this.datum.nodeManagerHttpPort;
    }

    public String getForcedJobStateOnShutDown() {
        return this.forcedJobStateOnShutDown;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public EventType getEventType() {
        return EventType.AM_STARTED;
    }
}

