/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.BoxData;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.GeoRssBox;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.GmlEnvelope;

public class BoxDataImpl
implements BoxData {
    private final ExtensionPoint extPoint;

    public BoxDataImpl(ExtensionPoint extensionPoint) {
        this.extPoint = extensionPoint;
    }

    public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
        this.setGeoBoundingBox(new GeoRssWhere(lowerLeft, upperRight));
    }

    public void setGeoBoundingBox(Box box) {
        BoxDataImpl.setBox(this.extPoint, box);
    }

    public Box getGeoBoundingBox() {
        return BoxDataImpl.getBox(this.extPoint);
    }

    public void clearGeoBoundingBox() {
        BoxDataImpl.clearBox(this.extPoint);
    }

    public static void setBox(ExtensionPoint ext, Box box) {
        Box existing = BoxDataImpl.getBoxExtension(ext);
        if (existing != null) {
            Point lowerLeft = box != null ? box.getLowerLeft() : null;
            Point upperRight = box != null ? box.getUpperRight() : null;
            existing.setGeoLocation(lowerLeft, upperRight);
        } else if (box != null) {
            ext.setExtension(box);
        }
    }

    public static Box getBox(ExtensionPoint ext) {
        Box b = BoxDataImpl.getBoxExtension(ext);
        if (b != null) {
            if (b instanceof GeoRssWhere) {
                GeoRssWhere geoWhere = (GeoRssWhere)b;
                if (geoWhere.hasBox()) {
                    return geoWhere;
                }
            } else {
                return b;
            }
        }
        return null;
    }

    static Box getBoxExtension(ExtensionPoint ext) {
        for (Extension e : ext.getExtensions()) {
            if (!(e instanceof Box)) continue;
            return (Box)e;
        }
        return null;
    }

    public static void clearBox(ExtensionPoint ext) {
        Box b = BoxDataImpl.getBoxExtension(ext);
        if (b != null) {
            GeoRssWhere where;
            if (b instanceof GeoRssWhere && (where = (GeoRssWhere)b).hasPoint()) {
                where.clearBox();
                return;
            }
            ext.removeExtension(b);
        }
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        Class<?> extClass = this.extPoint.getClass();
        extProfile.declare(extClass, GeoRssBox.getDefaultDescription(false));
        extProfile.declare(extClass, GeoRssWhere.getDefaultDescription(false));
        new GeoRssWhere().declareExtensions(extProfile);
        extProfile.declare(extClass, GmlEnvelope.getDefaultDescription(false));
        new GmlEnvelope().declareExtensions(extProfile);
    }
}

