/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.mapred.InputFormat;
import org.apache.oozie.action.hadoop.OozieLauncherInputFormat;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XLog;

class LauncherInputFormatClassLocator {
    private final XLog LOG = XLog.getLog(this.getClass());
    static final String HADOOP_INPUT_FORMAT_CLASSNAME = "mapreduce.input.format.class";
    private Class<? extends InputFormat> launcherInputFormatClass;

    LauncherInputFormatClassLocator() {
    }

    Class<? extends InputFormat> locateOrGet() {
        if (this.launcherInputFormatClass == null) {
            this.launcherInputFormatClass = this.locate();
        }
        return this.launcherInputFormatClass;
    }

    private Class<? extends InputFormat> locate() {
        String inputFormatClassName = OozieLauncherInputFormat.class.getSimpleName();
        String configuredClassName = ConfigurationService.get("oozie.action.launcher.mapreduce.input.format.class");
        if (configuredClassName != null) {
            inputFormatClassName = configuredClassName;
        }
        try {
            this.LOG.debug("Locating launcher input format class [{0}].", inputFormatClassName);
            Class<?> inputFormatClass = Class.forName(inputFormatClassName);
            this.LOG.debug("Launcher input format class [{0}] located successfully.", inputFormatClassName);
            return inputFormatClass;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            this.LOG.warn("Could not load class [{0}], located [{1}] instead.", inputFormatClassName, OozieLauncherInputFormat.class.getSimpleName());
            return OozieLauncherInputFormat.class;
        }
    }
}

