/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class ConfigurationService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "configuration";
    public static final String CONF_PREFIX = "oozie.service.ConfigurationService.";
    public static final String CONF_IGNORE_SYS_PROPS = "oozie.service.ConfigurationService.ignore.system.properties";
    public static final String CONF_VERIFY_AVAILABLE_PROPS = "oozie.service.ConfigurationService.verify.available.properties";
    public static final String OOZIE_CONFIG_DIR = "oozie.config.dir";
    public static final String OOZIE_DATA_DIR = "oozie.data.dir";
    public static final String OOZIE_CONFIG_FILE = "oozie.config.file";
    private static final Set<String> IGNORE_SYS_PROPS = new HashSet<String>();
    private static final Set<String> CONF_SYS_PROPS = new HashSet<String>();
    private static final String IGNORE_TEST_SYS_PROPS = "oozie.test.";
    private static final Set<String> MASK_PROPS = new HashSet<String>();
    private static Map<String, String> defaultConfigs = new HashMap<String, String>();
    private static Method getPasswordMethod;
    public static final String DEFAULT_CONFIG_FILE = "oozie-default.xml";
    public static final String SITE_CONFIG_FILE = "oozie-site.xml";
    private static XLog log;
    private String configDir;
    private String configFile;
    private LogChangesConfiguration configuration;

    public ConfigurationService() {
        log = XLog.getLog(ConfigurationService.class);
    }

    @Override
    public void init(Services services) throws ServiceException {
        this.configDir = ConfigurationService.getConfigurationDirectory();
        this.configFile = System.getProperty(OOZIE_CONFIG_FILE, SITE_CONFIG_FILE);
        if (this.configFile.contains("/")) {
            throw new ServiceException(ErrorCode.E0022, this.configFile);
        }
        log.info("Oozie home dir  [{0}]", Services.getOozieHome());
        log.info("Oozie conf dir  [{0}]", this.configDir);
        log.info("Oozie conf file [{0}]", this.configFile);
        this.configFile = new File(this.configDir, this.configFile).toString();
        this.configuration = this.loadConf();
        if (this.configuration.getBoolean(CONF_VERIFY_AVAILABLE_PROPS, false)) {
            this.verifyConfigurationName();
        }
    }

    public static String getConfigurationDirectory() throws ServiceException {
        File file;
        String oozieHome = Services.getOozieHome();
        String configDir = System.getProperty(OOZIE_CONFIG_DIR, null);
        File file2 = file = configDir == null ? new File(oozieHome, "conf") : new File(configDir);
        if (!file.exists()) {
            throw new ServiceException(ErrorCode.E0024, configDir);
        }
        return file.getPath();
    }

    @Override
    public void destroy() {
        this.configuration = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return ConfigurationService.class;
    }

    public Configuration getConf() {
        if (this.configuration == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.configuration;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    private InputStream getDefaultConfiguration() throws ServiceException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(DEFAULT_CONFIG_FILE);
        if (inputStream == null) {
            throw new ServiceException(ErrorCode.E0023, DEFAULT_CONFIG_FILE);
        }
        return inputStream;
    }

    private LogChangesConfiguration loadConf() throws ServiceException {
        String sysValue;
        String[] ignoreSysProps;
        Iterator<Object> i$;
        XConfiguration configuration;
        try {
            InputStream inputStream = this.getDefaultConfiguration();
            configuration = this.loadConfig(inputStream, true);
            File file = new File(this.configFile);
            if (!file.exists()) {
                log.info("Missing site configuration file [{0}]", this.configFile);
            } else {
                inputStream = new FileInputStream(this.configFile);
                XConfiguration xConfiguration = this.loadConfig(inputStream, false);
                XConfiguration.injectDefaults(configuration, xConfiguration);
                configuration = xConfiguration;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0024, this.configFile, ex.getMessage(), ex);
        }
        if (log.isTraceEnabled()) {
            try {
                StringWriter writer = new StringWriter();
                i$ = configuration.iterator();
                while (i$.hasNext()) {
                    Map.Entry entry = (Map.Entry)i$.next();
                    String value = this.getValue(configuration, (String)entry.getKey());
                    writer.write(" " + (String)entry.getKey() + " = " + value + "\n");
                }
                writer.close();
                log.trace("Configuration:\n{0}---", writer.toString());
            }
            catch (IOException ex) {
                throw new ServiceException(ErrorCode.E0025, ex.getMessage(), ex);
            }
        }
        if ((ignoreSysProps = configuration.getStrings(CONF_IGNORE_SYS_PROPS)) != null) {
            IGNORE_SYS_PROPS.addAll(Arrays.asList(ignoreSysProps));
        }
        i$ = configuration.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            sysValue = System.getProperty((String)entry.getKey());
            if (sysValue == null || IGNORE_SYS_PROPS.contains(entry.getKey())) continue;
            log.info("Configuration change via System Property, [{0}]=[{1}]", entry.getKey(), sysValue);
            configuration.set((String)entry.getKey(), sysValue);
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            if (IGNORE_SYS_PROPS.contains(name) || !name.startsWith("oozie.") || name.startsWith(IGNORE_TEST_SYS_PROPS) || configuration.get(name) != null) continue;
            log.warn("System property [{0}] no defined in Oozie configuration, ignored", name);
        }
        for (String string : CONF_SYS_PROPS) {
            sysValue = System.getProperty(string);
            if (sysValue == null || IGNORE_SYS_PROPS.contains(string)) continue;
            log.info("Overriding configuration with system property. Key [{0}], Value [{1}] ", string, sysValue);
            configuration.set(string, sysValue);
        }
        return new LogChangesConfiguration(configuration);
    }

    private XConfiguration loadConfig(InputStream inputStream, boolean defaultConfig) throws IOException, ServiceException {
        XConfiguration configuration = new XConfiguration(inputStream);
        Iterator i$ = configuration.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            if (defaultConfig) {
                defaultConfigs.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            log.debug("Overriding configuration with oozie-site, [{0}]", entry.getKey());
        }
        return configuration;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable(INSTRUMENTATION_GROUP, "config.dir", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ConfigurationService.this.configDir;
            }
        });
        instr.addVariable(INSTRUMENTATION_GROUP, "config.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return ConfigurationService.this.configFile;
            }
        });
    }

    public Configuration getMaskedConfiguration() {
        XConfiguration maskedConf = new XConfiguration();
        Configuration conf = this.getConf();
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            String value = this.getValue(conf, name);
            maskedConf.set(name, value);
        }
        return maskedConf;
    }

    private String getValue(Configuration config, String key) {
        String value = MASK_PROPS.contains(key) ? "**MASKED**" : config.get(key);
        return value;
    }

    private String getDefaultOozieConfig(String name) {
        return defaultConfigs.get(name);
    }

    public void verifyConfigurationName() {
        Iterator i$ = this.configuration.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            if (this.getDefaultOozieConfig((String)entry.getKey()) != null) continue;
            log.warn("Invalid configuration defined, [{0}] ", entry.getKey());
        }
    }

    @VisibleForTesting
    public static void set(String name, String value) {
        Configuration conf = Services.get().getConf();
        conf.set(name, value);
    }

    @VisibleForTesting
    public static void setBoolean(String name, boolean value) {
        Configuration conf = Services.get().getConf();
        conf.setBoolean(name, value);
    }

    public static String get(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.get(conf, name);
    }

    public static String get(Configuration conf, String name) {
        return conf.get(name, ConfigUtils.STRING_DEFAULT);
    }

    public static String[] getStrings(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getStrings(conf, name);
    }

    public static String[] getStrings(Configuration conf, String name) {
        return conf.getStrings(name, new String[0]);
    }

    public static boolean getBoolean(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getBoolean(conf, name);
    }

    public static boolean getBoolean(Configuration conf, String name) {
        return conf.getBoolean(name, ConfigUtils.BOOLEAN_DEFAULT);
    }

    public static int getInt(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getInt(conf, name);
    }

    public static int getInt(String name, int defaultValue) {
        Configuration conf = Services.get().getConf();
        return conf.getInt(name, defaultValue);
    }

    public static int getInt(Configuration conf, String name) {
        return conf.getInt(name, ConfigUtils.INT_DEFAULT);
    }

    public static float getFloat(String name) {
        Configuration conf = Services.get().getConf();
        return conf.getFloat(name, ConfigUtils.FLOAT_DEFAULT);
    }

    public static long getLong(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getLong(conf, name);
    }

    public static long getLong(Configuration conf, String name) {
        return conf.getLong(name, ConfigUtils.LONG_DEFAULT);
    }

    public static Class<?>[] getClasses(String name) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getClasses(conf, name);
    }

    public static Class<?>[] getClasses(Configuration conf, String name) {
        return conf.getClasses(name, new Class[0]);
    }

    public static Class<?> getClass(Configuration conf, String name) {
        return conf.getClass(name, Object.class);
    }

    public static String getPassword(Configuration conf, String name) {
        return ConfigurationService.getPassword(conf, name, null);
    }

    public static String getPassword(Configuration conf, String name, String defaultValue) {
        if (getPasswordMethod != null) {
            try {
                char[] pass = (char[])getPasswordMethod.invoke((Object)conf, name);
                return pass == null ? defaultValue : new String(pass);
            }
            catch (IllegalAccessException e) {
                log.error(e);
                throw new IllegalArgumentException("Could not load password for [" + name + "]", e);
            }
            catch (InvocationTargetException e) {
                log.error(e);
                throw new IllegalArgumentException("Could not load password for [" + name + "]", e);
            }
        }
        return conf.get(name);
    }

    public static String getPassword(String name, String defaultValue) {
        Configuration conf = Services.get().getConf();
        return ConfigurationService.getPassword(conf, name, defaultValue);
    }

    static {
        IGNORE_SYS_PROPS.add(CONF_IGNORE_SYS_PROPS);
        IGNORE_SYS_PROPS.add("oozie.home.dir");
        IGNORE_SYS_PROPS.add(OOZIE_CONFIG_DIR);
        IGNORE_SYS_PROPS.add(OOZIE_CONFIG_FILE);
        IGNORE_SYS_PROPS.add(OOZIE_DATA_DIR);
        IGNORE_SYS_PROPS.add("oozie.log.dir");
        IGNORE_SYS_PROPS.add("oozie.log4j.file");
        IGNORE_SYS_PROPS.add("oozie.log4j.reload");
        CONF_SYS_PROPS.add("oozie.http.hostname");
        CONF_SYS_PROPS.add("oozie.http.port");
        CONF_SYS_PROPS.add("oozie.https.port");
        CONF_SYS_PROPS.add("oozie.instance.id");
        MASK_PROPS.add("oozie.service.JPAService.jdbc.password");
        MASK_PROPS.add("oozie.authentication.signature.secret");
        try {
            getPasswordMethod = Configuration.class.getMethod("getPassword", String.class);
        }
        catch (NoSuchMethodException e) {
            getPasswordMethod = null;
        }
        log = XLog.getLog(ConfigurationService.class);
    }

    private class LogChangesConfiguration
    extends XConfiguration {
        public LogChangesConfiguration(Configuration conf) {
            for (Map.Entry entry : conf) {
                if (this.get((String)entry.getKey()) != null) continue;
                this.setValue((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public String[] getStrings(String name) {
            String s = this.get(name);
            return s != null && s.trim().length() > 0 ? super.getStrings(name) : new String[]{};
        }

        public String[] getStrings(String name, String[] defaultValue) {
            String s = this.get(name);
            if (s == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, Arrays.asList(defaultValue).toString());
            }
            return s != null && s.trim().length() > 0 ? super.getStrings(name) : defaultValue;
        }

        @Override
        public String get(String name, String defaultValue) {
            String value = this.get(name);
            if (value == null) {
                boolean maskValue = MASK_PROPS.contains(name);
                value = defaultValue;
                String logValue = maskValue ? "**MASKED**" : defaultValue;
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, logValue);
            }
            return value;
        }

        public void set(String name, String value) {
            this.setValue(name, value);
            boolean maskValue = MASK_PROPS.contains(name);
            value = maskValue ? "**MASKED**" : value;
            log.info(4, "Programmatic configuration change, property[{0}]=[{1}]", name, value);
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, defaultValue);
            }
            return super.getBoolean(name, defaultValue);
        }

        public int getInt(String name, int defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, defaultValue);
            }
            return super.getInt(name, defaultValue);
        }

        public long getLong(String name, long defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, defaultValue);
            }
            return super.getLong(name, defaultValue);
        }

        public float getFloat(String name, float defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, Float.valueOf(defaultValue));
            }
            return super.getFloat(name, defaultValue);
        }

        public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, defaultValue);
            }
            return super.getClasses(name, (Class[])defaultValue);
        }

        public Class<?> getClass(String name, Class<?> defaultValue) {
            String value = this.get(name);
            if (value == null) {
                log.debug(4, "Configuration property [{0}] not found, use given value [{1}]", name, defaultValue);
                return defaultValue;
            }
            try {
                return this.getClassByName(value);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private void setValue(String name, String value) {
            super.set(name, value);
        }
    }
}

