/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowLib;

public class LiteWorkflowAppService
extends WorkflowAppService {
    @Override
    public WorkflowApp parseDef(Configuration jobConf) throws WorkflowException {
        return this.parseDef(jobConf, null);
    }

    @Override
    public WorkflowApp parseDef(Configuration jobConf, Configuration configDefault) throws WorkflowException {
        String appPath = ParamChecker.notEmpty(jobConf.get("oozie.wf.application.path"), "oozie.wf.application.path");
        String user = ParamChecker.notEmpty(jobConf.get("user.name"), "user.name");
        String workflowXml = this.readDefinition(appPath, user, jobConf);
        return this.parseDef(workflowXml, jobConf, configDefault);
    }

    @Override
    public WorkflowApp parseDef(String wfXml, Configuration jobConf) throws WorkflowException {
        return this.parseDef(wfXml, jobConf, null);
    }

    public WorkflowApp parseDef(String workflowXml, Configuration jobConf, Configuration configDefault) throws WorkflowException {
        WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
        return workflowLib.parseDef(workflowXml, jobConf, configDefault);
    }
}

