/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.StatusTransitXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.StatusUtils;

public class CoordStatusTransitXCommand
extends StatusTransitXCommand {
    private final String jobId;
    private CoordinatorJobBean coordJob;
    int coordActionCount;
    private final Map<CoordinatorAction.Status, Integer> coordActionStatus = new HashMap<CoordinatorAction.Status, Integer>();
    boolean isPending = false;
    final boolean backwardSupportForCoordStatus = Services.get().getConf().getBoolean("oozie.service.StatusTransitService.backward.support.for.coord.status", false);

    public CoordStatusTransitXCommand(String jobId) {
        super("coord_status_transit", "coord_status_transit", 0);
        this.jobId = jobId;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, this.jobId);
            List<CoordinatorActionBean> coordActionStatusList = CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTIONS_STATUS_UNIGNORED, this.jobId);
            long count = (Long)CoordActionQueryExecutor.getInstance().getSingleValue(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTIONS_PENDING_COUNT, this.jobId);
            if (count > 0L) {
                this.isPending = true;
            }
            for (CoordinatorAction coordinatorAction : coordActionStatusList) {
                int counter = 0;
                counter = this.coordActionStatus.containsKey(coordinatorAction.getStatus()) ? this.getStatusCount(coordinatorAction.getStatus()) + 1 : ++counter;
                this.coordActionStatus.put(coordinatorAction.getStatus(), counter);
            }
            this.coordActionCount = coordActionStatusList.size();
        }
        catch (JPAExecutorException jpae) {
            throw new CommandException(ErrorCode.E1025, jpae);
        }
        LogUtils.setLogInfo(this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.backwardSupportForCoordStatus && this.coordJob.getAppNamespace() != null && this.coordJob.getAppNamespace().equals("uri:oozie:coordinator:0.1")) {
            throw new CommandException(ErrorCode.E1025, " Coord namespace is 0.1 and backward.support.for.coord.status is set");
        }
    }

    @Override
    protected Job.Status getJobStatus() throws CommandException {
        Job.Status jobStatus = super.getJobStatus();
        if (jobStatus == null) {
            jobStatus = this.coordJob.getStatus();
        }
        return jobStatus;
    }

    @Override
    protected boolean isTerminalState() {
        return (this.coordJob.isDoneMaterialization() || this.coordJob.getStatus() == Job.Status.FAILED || this.coordJob.getStatus() == Job.Status.KILLED) && this.isCoordTerminalStatus(this.coordActionCount);
    }

    @Override
    protected Job.Status getTerminalStatus() {
        if (this.coordJob.getStatus().equals((Object)Job.Status.KILLED)) {
            return Job.Status.KILLED;
        }
        if (this.coordActionCount == this.getStatusCount(CoordinatorAction.Status.SUCCEEDED) + this.getStatusCount(CoordinatorAction.Status.SKIPPED) && this.coordJob.isDoneMaterialization()) {
            return Job.Status.SUCCEEDED;
        }
        if (this.coordActionCount == this.getStatusCount(CoordinatorAction.Status.KILLED)) {
            return Job.Status.KILLED;
        }
        if (this.coordActionCount == this.getStatusCount(CoordinatorAction.Status.FAILED)) {
            return Job.Status.FAILED;
        }
        return Job.Status.DONEWITHERROR;
    }

    @Override
    protected boolean isPausedState() {
        return this.coordJob.getStatus().equals((Object)Job.Status.PAUSED) || this.coordJob.getStatus().equals((Object)Job.Status.PAUSEDWITHERROR);
    }

    @Override
    protected Job.Status getPausedState() {
        return this.hasTerminatedActions() ? Job.Status.PAUSEDWITHERROR : Job.Status.PAUSED;
    }

    @Override
    protected boolean isSuspendedState() {
        if (this.coordJob.getStatus() == Job.Status.SUSPENDED || this.coordJob.getStatus() == Job.Status.SUSPENDEDWITHERROR || this.coordJob.getStatus() == Job.Status.PREPSUSPENDED) {
            return true;
        }
        return this.getBottomUpSuspendedState() != null;
    }

    @Override
    protected Job.Status getSuspendedStatus() {
        if (this.coordJob.getStatus() == Job.Status.SUSPENDED || this.coordJob.getStatus() == Job.Status.SUSPENDEDWITHERROR) {
            return this.hasTerminatedActions() ? Job.Status.SUSPENDEDWITHERROR : Job.Status.SUSPENDED;
        }
        if (this.coordJob.getStatus() == Job.Status.PREPSUSPENDED) {
            return Job.Status.PREPSUSPENDED;
        }
        return this.getBottomUpSuspendedState();
    }

    @Override
    protected boolean isRunningState() {
        return this.coordJob.getStatus() != Job.Status.PREP;
    }

    @Override
    protected Job.Status getRunningState() {
        return this.hasTerminatedActions() ? Job.Status.RUNNINGWITHERROR : Job.Status.RUNNING;
    }

    @Override
    protected void updateJobStatus(Job.Status coordStatus) throws JPAExecutorException, CommandException {
        boolean isPendingStateChanged;
        Job.Status prevStatus = this.coordJob.getStatus();
        boolean prevPending = this.coordJob.isPending();
        if (this.isPending) {
            this.coordJob.setPending();
        } else {
            this.coordJob.resetPending();
        }
        boolean bl = isPendingStateChanged = prevPending != this.coordJob.isPending();
        if (this.coordJob.isTerminalStatus() && (coordStatus == Job.Status.SUSPENDED || coordStatus == Job.Status.SUSPENDEDWITHERROR)) {
            this.LOG.info("Coord Job [" + this.coordJob.getId() + "] status to " + coordStatus + " can not be updated as its already in Terminal state");
            if (isPendingStateChanged) {
                this.LOG.info("Pending for job  [" + this.coordJob.getId() + "] is changed to to '" + this.coordJob.isPending() + "' from '" + prevStatus + "'");
                this.coordJob.setLastModifiedTime(new Date());
                CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_MODTIME, this.coordJob);
            }
            return;
        }
        this.coordJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(coordStatus));
        this.coordJob.setStatus(StatusUtils.getStatus(this.coordJob));
        if (this.coordJob.getStatus() != prevStatus || isPendingStateChanged) {
            this.LOG.info("Set coordinator job [" + this.coordJob.getId() + "] status to '" + this.coordJob.getStatus() + "' from '" + prevStatus + "'");
            this.coordJob.setLastModifiedTime(new Date());
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_MODTIME, this.coordJob);
        }
        if (this.coordJob.getBundleId() != null && !prevStatus.equals((Object)this.coordJob.getStatus())) {
            new BundleStatusUpdateXCommand(this.coordJob, prevStatus).call();
        }
    }

    protected Job.Status getBottomUpSuspendedState() {
        if (this.coordJob.isDoneMaterialization() && !this.isPending && this.coordActionStatus.containsKey(CoordinatorAction.Status.SUSPENDED)) {
            if (this.coordActionCount == this.getStatusCount(CoordinatorAction.Status.SUSPENDED) + this.getStatusCount(CoordinatorAction.Status.SUCCEEDED)) {
                return Job.Status.SUSPENDED;
            }
            if (this.coordActionCount == this.getStatusCount(CoordinatorAction.Status.SUSPENDED) + this.getStatusCount(CoordinatorAction.Status.SUCCEEDED) + this.getStatusCount(CoordinatorAction.Status.KILLED) + this.getStatusCount(CoordinatorAction.Status.FAILED) + this.getStatusCount(CoordinatorAction.Status.TIMEDOUT)) {
                return Job.Status.SUSPENDEDWITHERROR;
            }
        }
        return null;
    }

    private boolean isCoordTerminalStatus(int coordActionsCount) {
        return coordActionsCount == this.getStatusCount(CoordinatorAction.Status.SUCCEEDED) + this.getStatusCount(CoordinatorAction.Status.FAILED) + this.getStatusCount(CoordinatorAction.Status.KILLED) + this.getStatusCount(CoordinatorAction.Status.TIMEDOUT) + this.getStatusCount(CoordinatorAction.Status.SKIPPED);
    }

    private int getStatusCount(CoordinatorAction.Status status) {
        int statusCount = 0;
        if (this.coordActionStatus.containsKey(status)) {
            statusCount = this.coordActionStatus.get(status);
        }
        return statusCount;
    }

    private boolean hasTerminatedActions() {
        return this.coordActionStatus.containsKey(CoordinatorAction.Status.KILLED) || this.coordActionStatus.containsKey(CoordinatorAction.Status.FAILED) || this.coordActionStatus.containsKey(CoordinatorAction.Status.TIMEDOUT);
    }
}

