/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.event;

import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.util.XLog;

public class WorkflowJobEvent
extends JobEvent {
    private WorkflowJob.Status status;
    private String errorCode;
    private String errorMessage;

    public WorkflowJobEvent(String id, String parentId, WorkflowJob.Status status, String user, String appName, Date startTime, Date endTime) {
        super(id, parentId, user, AppType.WORKFLOW_JOB, appName);
        this.setStatus(status);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        XLog.getLog(EventHandlerService.class).trace("Event generated - " + this.toString());
    }

    public String getCoordJobId() {
        return null;
    }

    public WorkflowJob.Status getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String code) {
        this.errorCode = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setStatus(WorkflowJob.Status wfstatus) {
        this.status = wfstatus;
        switch (this.status) {
            case SUCCEEDED: {
                this.setEventStatus(JobEvent.EventStatus.SUCCESS);
                break;
            }
            case RUNNING: {
                this.setEventStatus(JobEvent.EventStatus.STARTED);
                break;
            }
            case SUSPENDED: {
                this.setEventStatus(JobEvent.EventStatus.SUSPEND);
                break;
            }
            case KILLED: 
            case FAILED: {
                this.setEventStatus(JobEvent.EventStatus.FAILURE);
            }
        }
    }
}

