/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class StringSerializationUtil {
    private static final String DATA_VERSION = "V==1";
    private static final int CONVERSION_TRESHOLD = 60000;

    private StringSerializationUtil() {
    }

    public static void writeString(DataOutput dOut, String value) throws IOException {
        if (value == null) {
            dOut.writeUTF(value);
            return;
        }
        byte[] data = value.getBytes(StandardCharsets.UTF_8.name());
        if (data.length > 60000) {
            dOut.writeUTF(DATA_VERSION);
            dOut.writeInt(data.length);
            dOut.write(data);
        } else {
            dOut.writeUTF(value);
        }
    }

    public static String readString(DataInput dIn) throws IOException {
        String value = dIn.readUTF();
        if (DATA_VERSION.equals(value)) {
            int length = dIn.readInt();
            byte[] data = new byte[length];
            dIn.readFully(data);
            value = new String(data, StandardCharsets.UTF_8.name());
        }
        return value;
    }
}

