/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.oozie.util.XLog;

public class RuntimeExceptionInjector<E extends RuntimeException> {
    private static final XLog LOG = XLog.getLog(RuntimeExceptionInjector.class);
    private static final AtomicLong failureCounter = new AtomicLong(0L);
    private final Class<E> runtimeExceptionClass;
    private final int failurePercent;

    public RuntimeExceptionInjector(Class<E> runtimeExceptionClass, int failurePercent) {
        Preconditions.checkArgument((failurePercent <= 100 && failurePercent >= 0 ? 1 : 0) != 0, (Object)("illegal value for failure %: " + failurePercent));
        this.runtimeExceptionClass = runtimeExceptionClass;
        this.failurePercent = failurePercent;
    }

    public void inject(String errorMessage) {
        LOG.trace("Trying to inject random failure. [errorMessage={0}]", errorMessage);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int randomVal = random.nextInt(0, 100);
        if (randomVal < this.failurePercent) {
            RuntimeException injected;
            long count = failureCounter.incrementAndGet();
            LOG.warn("Injecting random failure. [runtimeExceptionClass.name={0};count={1};errorMessage={2}]", this.runtimeExceptionClass.getName(), count, errorMessage);
            try {
                injected = (RuntimeException)this.runtimeExceptionClass.getConstructor(String.class).newInstance("injected random failure #" + count + " ." + errorMessage);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException outer) {
                try {
                    LOG.warn("Instantiating without error message. [runtimeExceptionClass.name={0};outer.message={1}]", this.runtimeExceptionClass.getName(), outer.getMessage());
                    injected = (RuntimeException)this.runtimeExceptionClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException inner) {
                    LOG.error("Could not instantiate. [runtimeExceptionClass.name={0};inner.message={1}]", this.runtimeExceptionClass.getName(), inner.getMessage());
                    throw new RuntimeException(inner);
                }
            }
            throw injected;
        }
        LOG.trace("Did not inject random failure.");
    }
}

