/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreOwnerPermissions;
import org.pentaho.metastore.stores.xml.XmlMetaStoreAttribute;
import org.pentaho.metastore.stores.xml.XmlMetaStoreElementOwner;
import org.pentaho.metastore.stores.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMetaStoreElement
extends XmlMetaStoreAttribute
implements IMetaStoreElement {
    public static final String XML_TAG = "element";
    protected String name;
    protected IMetaStoreElementType elementType;
    protected XmlMetaStoreElementOwner owner;
    protected List<MetaStoreOwnerPermissions> ownerPermissionsList;

    public XmlMetaStoreElement() {
        this.ownerPermissionsList = new ArrayList<MetaStoreOwnerPermissions>();
    }

    public XmlMetaStoreElement(IMetaStoreElementType elementType, String id, Object value) {
        super(id, value);
        this.elementType = elementType;
        this.ownerPermissionsList = new ArrayList<MetaStoreOwnerPermissions>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XmlMetaStoreElement)) {
            return false;
        }
        return ((XmlMetaStoreElement)obj).id.equals(this.id);
    }

    public XmlMetaStoreElement(String filename) throws MetaStoreException {
        this();
        this.setIdWithFilename(filename);
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            DocumentBuilderFactory documentBuilderFactory = XmlUtil.createSafeDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(in);
            Element dataTypeElement = document.getDocumentElement();
            this.loadElement(dataTypeElement);
            this.loadAttribute(dataTypeElement);
            this.loadSecurity(dataTypeElement);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to load XML metastore attribute from file '" + filename + "'", e);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setIdWithFilename(String filename) {
        File file = new File(filename);
        this.id = file.getName();
        this.id = this.id.substring(0, this.id.length() - 4);
    }

    protected void loadElement(Node elementNode) {
        NodeList childNodes = elementNode.getChildNodes();
        for (int e = 0; e < childNodes.getLength(); ++e) {
            Node childNode = childNodes.item(e);
            if (!"name".equals(childNode.getNodeName())) continue;
            this.name = XmlUtil.getNodeValue(childNode);
        }
    }

    public void save() throws MetaStoreException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.filename);
            DocumentBuilderFactory factory = XmlUtil.createSafeDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element element = doc.createElement(XML_TAG);
            doc.appendChild(element);
            this.appendAttribute(this, doc, element);
            this.appendElement(this, doc, element);
            this.appendSecurity(doc, element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (FileNotFoundException ex) {
            throw new MetaStoreException("The Annotation Group name is too long. Please try something shorter.", ex);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to save XML meta store element to file '" + this.filename + "'", e);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void appendElement(IMetaStoreElement element, Document doc, Element parentElement) {
        Element nameElement = doc.createElement("name");
        if (element.getName() != null) {
            nameElement.appendChild(doc.createTextNode(element.getName() == null ? "" : element.getName()));
        }
        parentElement.appendChild(nameElement);
    }

    protected void appendSecurity(Document doc, Element parentElement) {
        Element securityElement = doc.createElement("security");
        parentElement.appendChild(securityElement);
        Element ownerElement = doc.createElement("owner");
        securityElement.appendChild(ownerElement);
        if (this.owner != null) {
            this.owner.append(doc, ownerElement);
        }
        Element oplElement = doc.createElement("owner-permissions-list");
        securityElement.appendChild(oplElement);
        for (MetaStoreOwnerPermissions ownerPermissions : this.ownerPermissionsList) {
            Element opElement = doc.createElement("owner-permissions");
            oplElement.appendChild(opElement);
            ownerPermissions.append(doc, opElement);
        }
    }

    protected void loadSecurity(Node elementNode) throws MetaStoreException {
        NodeList childNodes = elementNode.getChildNodes();
        for (int c = 0; c < childNodes.getLength(); ++c) {
            Node childNode = childNodes.item(c);
            if (!"security".equals(childNode.getNodeName())) continue;
            NodeList securityNodes = childNode.getChildNodes();
            for (int s = 0; s < securityNodes.getLength(); ++s) {
                Node securityNode = securityNodes.item(s);
                if ("owner".equals(securityNode.getNodeName())) {
                    this.owner = new XmlMetaStoreElementOwner(securityNode);
                }
                if (!"owner-permissions-list".equals(securityNode.getNodeName())) continue;
                NodeList opNodes = securityNode.getChildNodes();
                for (int op = 0; op < opNodes.getLength(); ++op) {
                    Node opNode = opNodes.item(op);
                    if (!"owner-permissions".equals(opNode.getNodeName())) continue;
                    MetaStoreOwnerPermissions ownerPermissions = new MetaStoreOwnerPermissions(opNode);
                    this.ownerPermissionsList.add(ownerPermissions);
                }
            }
        }
    }

    public XmlMetaStoreElement(IMetaStoreElement element) {
        super(element);
        this.name = element.getName();
        this.ownerPermissionsList = new ArrayList<MetaStoreOwnerPermissions>();
        if (element.getOwner() != null) {
            this.owner = new XmlMetaStoreElementOwner(element.getOwner());
        }
        for (MetaStoreOwnerPermissions ownerPermissions : element.getOwnerPermissionsList()) {
            this.getOwnerPermissionsList().add(new MetaStoreOwnerPermissions(ownerPermissions.getOwner(), ownerPermissions.getPermissions()));
        }
    }

    @Override
    public IMetaStoreElementOwner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IMetaStoreElementOwner owner) {
        this.owner = new XmlMetaStoreElementOwner(owner);
    }

    @Override
    public List<MetaStoreOwnerPermissions> getOwnerPermissionsList() {
        return this.ownerPermissionsList;
    }

    @Override
    public void setOwnerPermissionsList(List<MetaStoreOwnerPermissions> ownerPermissions) {
        this.ownerPermissionsList = ownerPermissions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMetaStoreElementType getElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(IMetaStoreElementType elementType) {
        this.elementType = elementType;
    }
}

