/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.dependencies.Dependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;

public class FileDependency
extends Dependency {
    private static Log logger = LogFactory.getLog(FileDependency.class);
    protected String filePath;
    protected PathOrigin origin;
    protected IUrlProvider urlProvider;
    private String hash;
    protected boolean useChecksumVersion = true;

    public FileDependency(String version, PathOrigin origin, String path, IUrlProvider urlProvider) {
        this.filePath = path;
        this.hash = null;
        this.origin = origin;
        this.urlProvider = urlProvider;
    }

    protected String getCheckSum() {
        if (this.hash == null) {
            InputStream in = null;
            try {
                in = this.getFileInputStream();
                this.hash = Util.getMd5Digest(in);
            }
            catch (Exception e) {
                logger.error((Object)"Could not compute md5 checksum.", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return this.hash;
    }

    @Override
    public String getVersion() {
        return this.useChecksumVersion ? this.getCheckSum() : Long.toString(this.getTimeStamp());
    }

    protected long getTimeStamp() {
        return this.origin.getReader(this.getContentFactory()).getLastModified(this.filePath);
    }

    public InputStream getFileInputStream() throws IOException {
        if (this.getContentFactory() != null) {
            return this.origin.getReader(this.getContentFactory()).getFileInputStream(this.filePath);
        }
        logger.fatal((Object)String.format("Couldn't getFileInputStream() for filePath = '%s'. Unable to get ContentFactory.", this.filePath));
        return null;
    }

    @Override
    public String getDependencyInclude() {
        String version = this.getVersion();
        String urlAppend = version == null ? "" : "?v=" + version;
        return this.origin.getUrl(this.filePath, this.urlProvider) + urlAppend;
    }

    @Override
    public String getContents() throws IOException {
        return Util.toString(this.getFileInputStream());
    }

    public String getUrlFilePath() {
        return this.origin.getUrl(this.filePath, this.urlProvider);
    }

    protected IContentAccessFactory getContentFactory() {
        if (PluginEnvironment.env() != null) {
            return PluginEnvironment.env().getContentAccessFactory();
        }
        return null;
    }

    public String toString() {
        return this.filePath;
    }
}

