/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.vfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VFS;
import org.dom4j.Document;
import pt.webdetails.cpf.plugin.CorePlugin;
import pt.webdetails.cpf.repository.IRepositoryAccess;
import pt.webdetails.cpf.repository.IRepositoryFile;
import pt.webdetails.cpf.repository.IRepositoryFileFilter;
import pt.webdetails.cpf.repository.vfs.VfsRepositoryFile;
import pt.webdetails.cpf.session.IUserSession;
import pt.webdetails.cpf.utils.CharsetHelper;

public class VfsRepositoryAccess
implements IRepositoryAccess {
    protected static final Log log = LogFactory.getLog(VfsRepositoryAccess.class);
    private final String DEFAULT_REPO;
    private final String DEFAULT_SETTINGS;
    protected FileObject settings;
    protected FileObject repo;
    protected CorePlugin plugin;
    protected IUserSession session;

    public VfsRepositoryAccess() throws IOException {
        this.DEFAULT_REPO = this.createDefaultRepo();
        this.DEFAULT_SETTINGS = this.createDefaultSettings();
        try {
            this.setRepository(this.DEFAULT_REPO);
            this.setSettings(this.DEFAULT_SETTINGS);
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize VfsRepository", (Throwable)e);
        }
    }

    public VfsRepositoryAccess(String repo, String settings) {
        this.DEFAULT_REPO = "";
        this.DEFAULT_SETTINGS = "";
        try {
            this.setRepository(repo);
            this.setSettings(settings);
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize VfsRepository", (Throwable)e);
        }
    }

    public void setRepository(String path) {
        this.repo = this.setRepoPath(path);
    }

    public void setSettings(String path) {
        this.settings = this.setRepoPath(path);
    }

    private FileObject setRepoPath(String path) {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            return fileObject;
        }
        catch (Exception e) {
            log.error((Object)("Error setting path for repository: " + path), (Throwable)e);
            return null;
        }
    }

    public void setUserSession(IUserSession session) {
        this.session = session;
    }

    protected FileObject resolveFile(FileObject folder, String file) throws Exception {
        if (file == null || file.startsWith("/") || file.startsWith(".") || file.contains("/../")) {
            throw new IllegalArgumentException("Path cannot be null or start with \"/\" or \".\" - Illegal Path: " + file);
        }
        FileObject repoFile = folder.resolveFile(file);
        return repoFile;
    }

    @Override
    public boolean canWrite(String file) {
        try {
            FileObject f = this.resolveFile(this.repo, file);
            return f != null && f.isWriteable();
        }
        catch (Exception e) {
            log.error((Object)("Cannot check canWrite for " + file), (Throwable)e);
            return false;
        }
    }

    @Override
    public IRepositoryAccess.SaveFileStatus copySolutionFile(String fromFilePath, String toFilePath) throws IOException {
        try {
            FileObject to = this.resolveFile(this.repo, toFilePath);
            FileObject from = this.resolveFile(this.repo, fromFilePath);
            to.copyFrom(from, Selectors.SELECT_SELF);
            if (to != null && to.exists() && to.isReadable()) {
                return IRepositoryAccess.SaveFileStatus.OK;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot copy from " + fromFilePath + " to " + toFilePath), (Throwable)e);
        }
        return IRepositoryAccess.SaveFileStatus.FAIL;
    }

    @Override
    public boolean createFolder(String file) throws IOException {
        try {
            FileObject f = this.resolveFile(this.repo, file);
            f.createFolder();
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Cannot create folder at: " + file), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    @Override
    public String getJSON(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("getJSON is deprecated, not supported!");
    }

    @Override
    public String getJqueryFileTree(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException("getJqueryFileTree is deprecated, not supported!");
    }

    @Override
    public IRepositoryFile getRepositoryFile(String file, IRepositoryAccess.FileAccess fa) {
        try {
            FileObject f = this.resolveFile(this.repo, file);
            return new VfsRepositoryFile(this.repo, f);
        }
        catch (Exception e) {
            log.error((Object)("Cannot get repository file: " + file), (Throwable)e);
            return null;
        }
    }

    @Override
    public Document getResourceAsDocument(String arg0) throws IOException {
        throw new UnsupportedOperationException("getResourceAsDocument is deprecated, not supported!");
    }

    @Override
    public Document getResourceAsDocument(String arg0, IRepositoryAccess.FileAccess arg1) throws IOException {
        throw new UnsupportedOperationException("getResourceAsDocument is deprecated, not supported!");
    }

    @Override
    public String getResourceAsString(String file) throws IOException {
        return this.getResourceAsString(file, IRepositoryAccess.FileAccess.READ);
    }

    @Override
    public String getResourceAsString(String file, IRepositoryAccess.FileAccess access) throws IOException {
        try {
            IRepositoryFile rf = this.getRepositoryFile(file, access);
            return new String(rf.getData());
        }
        catch (Exception e) {
            log.error((Object)("Cannot get resource as string for: " + file), (Throwable)e);
            return null;
        }
    }

    @Override
    public InputStream getResourceInputStream(String file) throws FileNotFoundException {
        try {
            FileObject fo = this.repo.resolveFile(file);
            if (fo.exists()) {
                return fo.getContent().getInputStream();
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot getResourceInputStream for: " + file), (Throwable)e);
        }
        throw new FileNotFoundException("Cannot get input stream for: " + file);
    }

    @Override
    public InputStream getResourceInputStream(String file, IRepositoryAccess.FileAccess access) throws FileNotFoundException {
        return this.getResourceInputStream(file);
    }

    @Override
    public InputStream getResourceInputStream(String file, IRepositoryAccess.FileAccess acess, boolean getLocalizedResource) throws FileNotFoundException {
        return this.getResourceInputStream(file);
    }

    private FileObject resolvePluginDirectory(FileObject dir, String directory) throws Exception {
        FileObject base = dir;
        if (this.plugin != null) {
            base = this.resolveFile(base, this.plugin.getName());
        }
        return this.resolveFile(base, directory);
    }

    public IRepositoryFile[] getPluginFiles(String directory, IRepositoryAccess.FileAccess access) {
        try {
            if (this.settings != null) {
                FileObject p = this.resolvePluginDirectory(this.settings, directory);
                VfsRepositoryFile ir = new VfsRepositoryFile(this.settings, p);
                return ir.listFiles();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error getting plugin files for (" + this.plugin + ")  at: " + directory), (Throwable)e);
        }
        return new IRepositoryFile[0];
    }

    @Override
    public IRepositoryFile getSettingsFile(String file, IRepositoryAccess.FileAccess arg1) {
        try {
            if (this.settings != null) {
                FileObject p = this.resolvePluginDirectory(this.settings, file);
                return new VfsRepositoryFile(this.settings, p);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error getting plugin file for (" + this.plugin + ")  at: " + file), (Throwable)e);
        }
        return null;
    }

    @Override
    public IRepositoryFile[] getSettingsFileTree(String directory, final String fileExtension, IRepositoryAccess.FileAccess access) {
        try {
            if (this.settings != null) {
                FileObject p = this.resolvePluginDirectory(this.settings, directory);
                VfsRepositoryFile ir = new VfsRepositoryFile(this.settings, p);
                IRepositoryFile[] files = ir.listFiles(new IRepositoryFileFilter(){

                    @Override
                    public boolean accept(IRepositoryFile isf) {
                        return fileExtension != null && fileExtension.equals(isf.getExtension());
                    }
                });
                return files;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error getting plugin files for (" + this.plugin + ")  at: " + directory + " with extension: " + fileExtension), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getSettingsResourceAsString(String file) throws IOException {
        try {
            IRepositoryFile rf = this.getSettingsFile(file, IRepositoryAccess.FileAccess.READ);
            return new String(rf.getData());
        }
        catch (Exception e) {
            throw new IOException("Cannot get settings resource as string for: " + file, e);
        }
    }

    @Override
    public String getSolutionPath(String arg0) {
        String path = "";
        FileObject file = null;
        try {
            path = this.repo.getURL().toURI().getPath();
        }
        catch (FileSystemException ex) {
            Logger.getLogger(VfsRepositoryAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(VfsRepositoryAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (arg0 == null || arg0.isEmpty()) {
            return path;
        }
        if (arg0.startsWith("/")) {
            arg0 = arg0.substring(1);
        }
        try {
            file = this.resolveFile(this.repo, arg0);
            if (file != null && file.exists()) {
                return path + "/" + arg0;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(VfsRepositoryAccess.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public boolean hasAccess(String file, IRepositoryAccess.FileAccess access) {
        IRepositoryFile ir = this.getRepositoryFile(file, access);
        return ir.exists();
    }

    @Override
    public IRepositoryAccess.SaveFileStatus publishFile(String file, String contents, boolean overwrite) throws UnsupportedEncodingException {
        if (contents != null) {
            return this.publishFile(file, contents.getBytes(this.getEncoding()), overwrite);
        }
        return IRepositoryAccess.SaveFileStatus.FAIL;
    }

    @Override
    public IRepositoryAccess.SaveFileStatus publishFile(String file, byte[] content, boolean overwrite) {
        return this.publishFile(null, file, content, overwrite);
    }

    @Override
    public IRepositoryAccess.SaveFileStatus publishFile(String solutionPath, String file, byte[] content, boolean overwrite) {
        return this.publishFile(null, null, file, content, overwrite);
    }

    @Override
    public IRepositoryAccess.SaveFileStatus publishFile(String solution, String path, String fileName, byte[] data, boolean overwrite) {
        try {
            if (data != null) {
                String file = this.getRelativePath(path, solution, fileName);
                if (this.resourceExists(file)) {
                    if (this.canWrite(file) && overwrite) {
                        FileObject fileObject = this.resolveFile(this.repo, file);
                        fileObject.getContent().getOutputStream().write(data);
                        fileObject.getContent().close();
                        return IRepositoryAccess.SaveFileStatus.OK;
                    }
                    return IRepositoryAccess.SaveFileStatus.FAIL;
                }
                FileObject f = this.resolveFile(this.repo, file);
                f.getContent().getOutputStream().write(data);
                f.getContent().close();
                return IRepositoryAccess.SaveFileStatus.OK;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot publish file! solution: " + solution + " path: " + path + " file: " + fileName, e);
        }
        return IRepositoryAccess.SaveFileStatus.FAIL;
    }

    @Override
    public boolean removeFile(String file) {
        try {
            FileObject f = this.resolveFile(this.repo, file);
            if (f.exists()) {
                return f.delete();
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot delete file: " + file, e);
        }
    }

    @Override
    public boolean removeFileIfExists(String file) {
        return !this.resourceExists(file) || this.removeFile(file);
    }

    @Override
    public boolean resourceExists(String file) {
        try {
            FileObject ir = this.resolveFile(this.repo, file);
            return ir.exists();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot check if repo file exists: " + file, e);
        }
    }

    private String getRelativePath(String originalPath, String solution, String file) throws UnsupportedEncodingException {
        String joined = "";
        joined = joined + (StringUtils.isEmpty((String)solution) ? "" : solution + "/");
        joined = joined + (StringUtils.isEmpty((String)originalPath) ? "" : originalPath + "/");
        joined = joined + (StringUtils.isEmpty((String)file) ? "" : file);
        joined = joined.replaceAll("//", "/");
        return joined;
    }

    private String createDefaultRepo() throws IOException {
        String repo = System.getProperty("user.dir");
        this.setRepository(repo);
        repo = repo + "/cpf/repository";
        this.createFolder("cpf/repository");
        return repo;
    }

    private String createDefaultSettings() throws IOException {
        String sett = System.getProperty("user.dir");
        sett = sett + "/cpf/settings";
        this.createFolder("cpf/settings");
        return sett;
    }

    @Override
    public IRepositoryFile[] listRepositoryFiles(IRepositoryFileFilter fileFilter) {
        try {
            FileObject[] files = this.repo.getChildren();
            ArrayList<VfsRepositoryFile> repoFiles = new ArrayList<VfsRepositoryFile>();
            for (FileObject file : files) {
                if (!file.exists() || !file.isReadable() || !file.getType().equals(FileType.FILE)) continue;
                VfsRepositoryFile repoFile = new VfsRepositoryFile(this.repo, file);
                if (fileFilter != null && !fileFilter.accept(repoFile)) continue;
                repoFiles.add(repoFile);
            }
            return repoFiles.toArray(new IRepositoryFile[0]);
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Cannot list repo files", e);
        }
    }
}

