/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBExtendedData;
import com.ibm.as400.access.DBExtendedDataFormat;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.DBOriginalData;
import com.ibm.as400.access.DBOriginalDataFormat;
import com.ibm.as400.access.DBReplyPackageInfo;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBReplyServerAttributes;
import com.ibm.as400.access.DBReplyXids;
import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.DBSuperExtendedDataFormat;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

abstract class DBBaseReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String NODATA_ = "0";
    private static final int TEMPLATE_LENGTH_ = 20;
    private int errorClass_ = 0;
    private int returnCode_ = 0;
    private int byteCount_ = -1;
    private long currentLOBLength_ = -1L;
    private DBDataFormat dataFormat_ = null;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_ = null;
    private String firstLevelMessageText_ = null;
    private DBLobData lobData_ = null;
    private String messageId_ = null;
    private DBReplyPackageInfo packageInfo_ = null;
    private DBDataFormat parameterMarkerFormat_ = null;
    private DBData resultData_ = null;
    private boolean rleCompressed_ = false;
    private String secondLevelMessageText_ = null;
    private DBReplyServerAttributes serverAttributes_ = null;
    private DBReplySQLCA sqlca_ = null;
    private DBReplyXids xids_ = null;
    private final DBStorage storage_ = DBDSPool.storagePool_.getUnusedStorage();
    private int holdable = -1;
    private int scrollable = -1;
    private int updatable = -1;
    private int sensitive = -1;

    DBBaseReplyDS() {
    }

    final void initialize() {
        this.data_ = this.storage_.data_;
        this.errorClass_ = 0;
        this.returnCode_ = 0;
        this.byteCount_ = -1;
        this.currentLOBLength_ = -1L;
        this.dataFormat_ = null;
        this.firstLevelMessageText_ = null;
        this.lobData_ = null;
        this.messageId_ = null;
        this.packageInfo_ = null;
        this.parameterMarkerFormat_ = null;
        this.resultData_ = null;
        this.rleCompressed_ = false;
        this.secondLevelMessageText_ = null;
        this.serverAttributes_ = null;
        this.sqlca_ = null;
        this.xids_ = null;
        this.holdable = -1;
        this.scrollable = -1;
        this.updatable = -1;
        this.sensitive = -1;
        this.extendedColumnDescriptors_ = null;
    }

    void dump(PrintStream printStream) {
        DBBaseRequestDS.dump(printStream, this.data_, this.data_.length);
        if (this.rleCompressed_) {
            printStream.println("Reply was received RLE compressed.");
        }
    }

    public long getCurrentLOBLength() {
        return this.currentLOBLength_;
    }

    public int getCursorAttributeHoldable() {
        return this.holdable;
    }

    public int getCursorAttributeScrollable() {
        return this.scrollable;
    }

    public int getCursorAttributeUpdatable() {
        return this.updatable;
    }

    public int getCursorAttributeSensitive() {
        return this.sensitive;
    }

    public DBDataFormat getDataFormat() {
        return this.dataFormat_;
    }

    public int getErrorClass() {
        return this.errorClass_;
    }

    public DBExtendedColumnDescriptors getExtendedColumnDescriptors() {
        return this.extendedColumnDescriptors_;
    }

    public String getFirstLevelMessageText() {
        return this.firstLevelMessageText_;
    }

    public DBLobData getLOBData() {
        return this.lobData_;
    }

    public String getMessageId() {
        return this.messageId_;
    }

    public DBReplyPackageInfo getPackageInfo() {
        return this.packageInfo_;
    }

    public DBDataFormat getParameterMarkerFormat() {
        return this.parameterMarkerFormat_;
    }

    public DBData getResultData() {
        return this.resultData_;
    }

    public int getReturnCode() {
        return this.returnCode_;
    }

    public int getReturnDataFunctionId() {
        return this.get16bit(30);
    }

    public String getSecondLevelMessageText() {
        return this.secondLevelMessageText_;
    }

    public DBReplyServerAttributes getServerAttributes() {
        return this.serverAttributes_;
    }

    public DBReplySQLCA getSQLCA() {
        return this.sqlca_;
    }

    public DBReplyXids getXids() {
        return this.xids_;
    }

    public int readAfterHeader(InputStream inputStream) throws IOException {
        this.byteCount_ = super.readAfterHeader(inputStream);
        return this.byteCount_;
    }

    void parse(int n) throws IOException {
        int n2;
        int n3;
        boolean bl = (this.get16bit(20) & 1) == 1;
        boolean bl2 = (this.get32bit(24) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        boolean bl3 = bl2 && n == 1;
        boolean bl4 = this.rleCompressed_ = bl2 && n == 14386;
        if (this.rleCompressed_) {
            n3 = this.get16bit(44);
            if (n3 != 14386) {
                throw new IOException();
            }
            n2 = this.get32bit(46);
            byte[] byArray = new byte[n2 + 40];
            BinaryConverter.intToByteArray(byArray.length, byArray, 0);
            System.arraycopy(this.data_, 4, byArray, 4, 36);
            DataStreamCompression.decompressRLE(this.data_, 50, this.get32bit(0) - 50, byArray, 40, (byte)27);
            this.data_ = byArray;
            this.byteCount_ = this.data_.length - 20;
        }
        this.errorClass_ = this.get16bit(34);
        this.returnCode_ = this.get32bit(36);
        block23: for (n3 = 40; n3 < this.byteCount_ + 20; n3 += n2) {
            n2 = this.get32bit(n3);
            int n4 = this.get16bit(n3 + 4);
            switch (n4) {
                case 14337: {
                    if (n2 != 6) {
                        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(this.get16bit(n3 + 6), this.system_);
                        this.messageId_ = converterImplRemote.byteArrayToString(this.data_, n3 + 8, n2 - 8);
                        continue block23;
                    }
                    this.messageId_ = NODATA_;
                    continue block23;
                }
                case 14338: {
                    if (n2 != 6) {
                        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(this.get16bit(n3 + 6), this.system_);
                        this.firstLevelMessageText_ = converterImplRemote.byteArrayToString(this.data_, n3 + 10, n2 - 10);
                        continue block23;
                    }
                    this.firstLevelMessageText_ = NODATA_;
                    continue block23;
                }
                case 14339: {
                    if (n2 != 6) {
                        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(this.get16bit(n3 + 6), this.system_);
                        this.secondLevelMessageText_ = converterImplRemote.byteArrayToString(this.data_, n3 + 10, n2 - 10);
                        continue block23;
                    }
                    this.secondLevelMessageText_ = NODATA_;
                    continue block23;
                }
                case 14340: {
                    try {
                        this.serverAttributes_ = new DBReplyServerAttributes(this.data_, n3 + 8, n2);
                        continue block23;
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        throw new IOException();
                    }
                }
                case 14341: {
                    if (n2 != 6) {
                        this.dataFormat_ = new DBOriginalDataFormat();
                        this.dataFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty data format.");
                    continue block23;
                }
                case 14342: {
                    if (n2 != 6) {
                        this.resultData_ = new DBOriginalData(n2, bl3);
                        this.resultData_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty result data.");
                    continue block23;
                }
                case 14343: {
                    this.sqlca_ = new DBReplySQLCA(this.data_, n3 + 6, n2);
                    continue block23;
                }
                case 14344: {
                    if (n2 != 6) {
                        this.parameterMarkerFormat_ = new DBOriginalDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty parameter marker format.");
                    continue block23;
                }
                case 14347: {
                    this.packageInfo_ = new DBReplyPackageInfo(this.data_, n3 + 6, n2, this.system_.getCcsid());
                    continue block23;
                }
                case 14348: {
                    if (n2 != 6) {
                        this.dataFormat_ = new DBExtendedDataFormat();
                        this.dataFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty extended data format.");
                    continue block23;
                }
                case 14349: {
                    if (n2 != 6) {
                        this.parameterMarkerFormat_ = new DBExtendedDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty extended parameter marker format.");
                    continue block23;
                }
                case 14350: {
                    if (n2 != 6) {
                        this.resultData_ = new DBExtendedData(n2, bl3, bl);
                        this.resultData_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty extended result data.");
                    continue block23;
                }
                case 14351: {
                    if (n2 != 6) {
                        int n5 = this.get32bit(n3 + 8);
                        this.lobData_ = new DBLobData(n5, n2 - 12, bl3);
                        this.lobData_.overlay(this.data_, n3 + 12);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty lob locator.");
                    continue block23;
                }
                case 14352: {
                    int n6 = this.get16bit(n3 + 6);
                    if (n6 == 0) {
                        this.currentLOBLength_ = 0L;
                        continue block23;
                    }
                    if (n6 == 4) {
                        this.currentLOBLength_ = this.get32bit(n3 + 8);
                        continue block23;
                    }
                    this.currentLOBLength_ = this.get64bit(n3 + 8);
                    continue block23;
                }
                case 14497: {
                    this.xids_ = new DBReplyXids(this.data_, n3, n2);
                    continue block23;
                }
                case 14353: {
                    if (n2 != 6) {
                        this.extendedColumnDescriptors_ = new DBExtendedColumnDescriptors(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty extended column descriptor.");
                    continue block23;
                }
                case 14354: {
                    if (n2 != 6) {
                        this.dataFormat_ = new DBSuperExtendedDataFormat();
                        this.dataFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty super extended data format.");
                    continue block23;
                }
                case 14355: {
                    if (n2 != 6) {
                        this.parameterMarkerFormat_ = new DBSuperExtendedDataFormat();
                        this.parameterMarkerFormat_.overlay(this.data_, n3 + 6);
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty parameter marker format.");
                    continue block23;
                }
                case 14356: {
                    if (n2 != 6) {
                        int n7 = this.get32bit(n3 + 6);
                        this.holdable = n7 >> 24 & 1;
                        this.scrollable = n7 >> 16 & 1;
                        this.updatable = n7 >> 8 & 1;
                        this.sensitive = (n7 >> 0 & 1) == 1 ? 0 : 1;
                        continue block23;
                    }
                    if (!Trace.traceOn_) continue block23;
                    Trace.log(1, "Received empty cursor attributes.");
                }
            }
        }
    }
}

