/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class DecimalDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 15;
    private BigDecimal initialValue_ = new BigDecimal("0.0");
    private int decimalPositions_ = 5;

    public DecimalDataArea() {
        this.length_ = 15;
        this.dataAreaType_ = 2;
    }

    public DecimalDataArea(AS400 aS400, String string) {
        super(aS400, string);
        this.length_ = 15;
        this.dataAreaType_ = 2;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.create(this.length_, this.decimalPositions_, this.initialValue_, this.textDescription_, this.authority_);
        this.fireCreated();
    }

    public void create(int n, int n2, BigDecimal bigDecimal, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (n < 1 || n > 24) {
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (n2 < 0 || n2 > 9) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 4);
        }
        if (n2 > n) {
            throw new ExtendedIllegalArgumentException("decimalPositions", 2);
        }
        if (bigDecimal == null) {
            throw new NullPointerException("initialValue");
        }
        if (string == null) {
            throw new NullPointerException("textDescription");
        }
        if (string.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("authority");
        }
        if (string2.length() == 0 || string2.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority", 1);
        }
        this.length_ = n;
        this.decimalPositions_ = n2;
        this.initialValue_ = bigDecimal;
        this.textDescription_ = string;
        this.authority_ = string2;
        this.create();
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.delete0();
    }

    public int getDecimalPositions() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getDecimalPositions();
    }

    public String getPath() {
        return super.getPath();
    }

    public BigDecimal read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        BigDecimal bigDecimal = this.impl_.readBigDecimal();
        this.fireRead();
        return bigDecimal;
    }

    public void setPath(String string) throws PropertyVetoException {
        super.setPath(string);
    }

    public void write(BigDecimal bigDecimal) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (bigDecimal == null) {
            throw new NullPointerException("data");
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(bigDecimal);
        this.fireWritten();
    }
}

