/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLMetaDataTableModel;
import com.ibm.as400.vaccess.SQLQueryGroupPane;
import com.ibm.as400.vaccess.SQLQueryHavingPane;
import com.ibm.as400.vaccess.SQLQueryJoinPane;
import com.ibm.as400.vaccess.SQLQueryOrderPane;
import com.ibm.as400.vaccess.SQLQuerySelectPane;
import com.ibm.as400.vaccess.SQLQuerySummaryPane;
import com.ibm.as400.vaccess.SQLQueryTablePane;
import com.ibm.as400.vaccess.SQLQueryWherePane;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SQLQueryBuilderPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SQLConnection sqlconn_ = null;
    private String[] tables_;
    private String[] schemas_ = new String[0];
    private transient Connection connection_ = null;
    private boolean tablesUserDefined_ = true;
    private boolean schemasUserDefined_ = true;
    transient JTabbedPane notebook_;
    private transient SQLQueryTablePane tablePane_;
    private transient SQLQuerySelectPane selectPane_;
    private transient SQLQueryJoinPane joinPane_;
    private transient SQLQueryWherePane wherePane_;
    private transient SQLQueryGroupPane groupPane_;
    private transient SQLQueryHavingPane havingPane_;
    private transient SQLQueryOrderPane orderPane_;
    private transient SQLQuerySummaryPane summaryPane_;
    static final int TABLE_ = 0;
    static final int SELECT_ = 1;
    static final int JOIN_ = 2;
    static final int WHERE_ = 3;
    static final int GROUP_ = 4;
    static final int HAVING_ = 5;
    static final int ORDER_ = 6;
    static final int SUMMARY_ = 7;
    transient int currentPane_ = 0;
    private transient boolean[] panelInit = new boolean[8];
    transient SQLMetaDataTableModel fields_ = null;
    private transient PropertyChangeSupport fieldListeners_ = new PropertyChangeSupport(this);
    private boolean internalLoad_ = false;
    private transient boolean loadDone_ = false;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport panelErrors_ = new ErrorEventSupport(this);
    transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    transient WorkingEvent workEvent_ = new WorkingEvent(this);

    public SQLQueryBuilderPane() {
        this.tables_ = new String[0];
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public SQLQueryBuilderPane(SQLConnection sQLConnection) {
        this.sqlconn_ = sQLConnection;
        this.tables_ = new String[0];
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public SQLQueryBuilderPane(SQLConnection sQLConnection, String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("tables");
        }
        this.sqlconn_ = sQLConnection;
        this.tables_ = stringArray;
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.panelErrors_.addErrorListener(errorListener);
    }

    void addFieldListener(PropertyChangeListener propertyChangeListener) {
        this.fieldListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    void addSelectListener(PropertyChangeListener propertyChangeListener) {
        this.selectPane_.addSelectListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
        super.addVetoableChangeListener(vetoableChangeListener);
    }

    synchronized void completePage() {
        Trace.log(1, "Completing page " + this.currentPane_);
        switch (this.currentPane_) {
            case 0: {
                this.tablePane_.complete();
                if (this.tablePane_.getSchemas() != this.schemas_) {
                    try {
                        this.setTableSchemas(this.tablePane_.getSchemas());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        this.tablePane_.setSchemas(this.schemas_);
                    }
                }
                if (this.tablePane_.getTables() == this.tables_) break;
                try {
                    this.setTables(this.tablePane_.getTables());
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.tablePane_.setTables(this.tables_);
                }
                this.internalLoad_ = true;
                this.load();
                this.internalLoad_ = false;
                if (this.tables_.length == 0) {
                    this.notebook_.setEnabledAt(1, false);
                    this.notebook_.setEnabledAt(2, false);
                    this.notebook_.setEnabledAt(3, false);
                    this.notebook_.setEnabledAt(4, false);
                    this.notebook_.setEnabledAt(5, false);
                    this.notebook_.setEnabledAt(6, false);
                    break;
                }
                this.notebook_.setEnabledAt(1, true);
                this.notebook_.setEnabledAt(3, true);
                this.notebook_.setEnabledAt(4, true);
                this.notebook_.setEnabledAt(5, true);
                if (this.tables_.length == 1) {
                    this.notebook_.setEnabledAt(2, false);
                } else {
                    this.notebook_.setEnabledAt(2, true);
                }
                if (this.selectPane_.getSelectedItems().length > 0) {
                    this.notebook_.setEnabledAt(6, true);
                    break;
                }
                this.notebook_.setEnabledAt(6, false);
                break;
            }
            case 1: {
                this.selectPane_.complete();
                if (this.selectPane_.getSelectedItems().length > 0) {
                    this.notebook_.setEnabledAt(6, true);
                    break;
                }
                this.notebook_.setEnabledAt(6, false);
                break;
            }
            case 2: {
                this.joinPane_.complete();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                Trace.log(2, "Unknown page " + this.currentPane_);
            }
        }
    }

    public SQLConnection getConnection() {
        return this.sqlconn_;
    }

    public synchronized String getQuery() {
        String string;
        this.completePage();
        if (this.tables_.length == 0) {
            return "";
        }
        this.worker_.startWorking(this.workEvent_);
        StringBuffer stringBuffer = new StringBuffer("SELECT " + this.selectPane_.getClause());
        boolean bl = false;
        boolean bl2 = false;
        if (this.tables_.length > 1) {
            if (this.joinPane_.getJoinType() == 1) {
                string = this.joinPane_.getClause(0);
                if (string != null && !string.equals("")) {
                    stringBuffer.append(" FROM ");
                    for (int i = 0; i < this.tables_.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.tables_[i]);
                        stringBuffer.append(" AS ");
                        stringBuffer.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
                    }
                    bl2 = true;
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(string);
                    String string2 = this.wherePane_.getClause();
                    if (string2 != null && !string2.equals("")) {
                        stringBuffer.append(" AND ");
                        stringBuffer.append(string2);
                    }
                    bl = true;
                }
            } else {
                stringBuffer.append(" FROM ");
                stringBuffer.append(this.tables_[0]);
                stringBuffer.append(" AS ");
                stringBuffer.append(this.tables_[0].substring(this.tables_[0].lastIndexOf(".") + 1));
                int n = 0;
                while (n < this.tables_.length - 1) {
                    string = this.joinPane_.getClause(n).trim();
                    if (string.equals("")) {
                        stringBuffer.append(", ");
                        stringBuffer.append(this.tables_[++n]);
                        stringBuffer.append(" AS ");
                        stringBuffer.append(this.tables_[n].substring(this.tables_[n].lastIndexOf(".") + 1));
                        continue;
                    }
                    stringBuffer.append(" LEFT JOIN ");
                    stringBuffer.append(this.tables_[++n]);
                    stringBuffer.append(" AS ");
                    stringBuffer.append(this.tables_[n].substring(this.tables_[n].lastIndexOf(".") + 1));
                    stringBuffer.append(" ON ");
                    stringBuffer.append(string);
                }
                bl2 = true;
            }
        }
        if (!bl2) {
            stringBuffer.append(" FROM ");
            for (int i = 0; i < this.tables_.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.tables_[i]);
                stringBuffer.append(" AS ");
                stringBuffer.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
            }
        }
        if (!bl && (string = this.wherePane_.getClause()) != null && !string.equals("")) {
            stringBuffer.append(" WHERE ");
            stringBuffer.append(string);
        }
        if ((string = this.groupPane_.getClause()) != null && !string.equals("")) {
            stringBuffer.append(" GROUP BY ");
            stringBuffer.append(string);
        }
        if ((string = this.havingPane_.getClause()) != null && !string.equals("")) {
            stringBuffer.append(" HAVING ");
            stringBuffer.append(string);
        }
        if ((string = this.orderPane_.getClause()) != null && !string.equals("")) {
            stringBuffer.append(" ORDER BY ");
            stringBuffer.append(string);
        }
        this.worker_.stopWorking(this.workEvent_);
        return stringBuffer.toString();
    }

    synchronized String[] getSelectedFields() {
        this.worker_.startWorking(this.workEvent_);
        String[] stringArray = this.selectPane_.getSelectedFields();
        this.worker_.stopWorking(this.workEvent_);
        return stringArray;
    }

    synchronized String[] getSelectedItems() {
        this.worker_.startWorking(this.workEvent_);
        String[] stringArray = this.selectPane_.getSelectedItems();
        this.worker_.stopWorking(this.workEvent_);
        return stringArray;
    }

    public String[] getTables() {
        return this.tables_;
    }

    public String[] getTableSchemas() {
        return this.schemas_;
    }

    public boolean getUserSelectTables() {
        return this.tablesUserDefined_;
    }

    public boolean getUserSelectTableSchemas() {
        return this.schemasUserDefined_;
    }

    public synchronized void load() {
        Trace.log(1, "Doing query builder load");
        this.worker_.startWorking(this.workEvent_);
        if (this.currentPane_ != 0) {
            this.completePage();
        }
        if (!this.internalLoad_) {
            if (this.sqlconn_ == null) {
                this.sqlconn_ = new SQLConnection("jdbc:as400");
            }
            this.connection_ = null;
            try {
                this.connection_ = this.sqlconn_.getConnection();
            }
            catch (SQLException sQLException) {
                this.panelErrors_.fireError(sQLException);
                return;
            }
        }
        this.fields_.setConnection(this.connection_);
        this.fields_.setTables(this.tables_);
        this.fields_.load();
        this.fieldListeners_.firePropertyChange(null, null, null);
        if (!this.internalLoad_) {
            this.tablePane_.setConnection(this.connection_);
            this.tablePane_.setTables(this.tables_);
            this.tablePane_.load();
            if (this.tablesUserDefined_) {
                this.tablePane_.setEnabled(true);
            }
            this.updatePage();
        }
        this.worker_.stopWorking(this.workEvent_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addFocusListener(new SerializationListener(this));
        this.panelInit = new boolean[8];
        this.fieldListeners_ = new PropertyChangeSupport(this);
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.panelErrors_ = new ErrorEventSupport(this);
        this.fields_ = null;
        this.worker_ = new WorkingCursorAdapter(this);
        this.workEvent_ = new WorkingEvent(this);
        this.currentPane_ = 0;
        this.loadDone_ = false;
        this.setupPane();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.panelErrors_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
        super.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        SQLConnection sQLConnection2 = this.sqlconn_;
        this.vetoListeners_.fireVetoableChange("connection", sQLConnection2, sQLConnection);
        this.sqlconn_ = sQLConnection;
        this.changeListeners_.firePropertyChange("connection", sQLConnection2, sQLConnection);
    }

    public void setTables(String[] stringArray) throws PropertyVetoException {
        if (stringArray == null) {
            throw new NullPointerException("tables");
        }
        String[] stringArray2 = this.tables_;
        this.vetoListeners_.fireVetoableChange("tables", stringArray2, stringArray);
        this.tables_ = stringArray;
        this.changeListeners_.firePropertyChange("tables", stringArray2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableSchemas(String[] stringArray) throws PropertyVetoException {
        if (stringArray == null) {
            throw new NullPointerException("tableSchemas");
        }
        String[] stringArray2 = this.schemas_;
        this.vetoListeners_.fireVetoableChange("tableSchemas", stringArray2, stringArray);
        SQLQueryBuilderPane sQLQueryBuilderPane = this;
        synchronized (sQLQueryBuilderPane) {
            this.schemas_ = stringArray;
            this.tablePane_.setSchemas(stringArray);
        }
        this.changeListeners_.firePropertyChange("tableSchemas", stringArray2, stringArray);
    }

    public void setUserSelectTables(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(this.tablesUserDefined_);
        this.vetoListeners_.fireVetoableChange("userSelectTables", bl2, new Boolean(bl));
        this.tablesUserDefined_ = bl;
        this.tablePane_.setEnabled(bl);
        this.changeListeners_.firePropertyChange("userSelectTables", bl2, new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSelectTableSchemas(boolean bl) throws PropertyVetoException {
        this.vetoListeners_.fireVetoableChange("userSelectTableSchemas", new Boolean(this.schemasUserDefined_), new Boolean(bl));
        boolean bl2 = this.schemasUserDefined_;
        this.schemasUserDefined_ = bl;
        SQLQueryBuilderPane sQLQueryBuilderPane = this;
        synchronized (sQLQueryBuilderPane) {
            this.tablePane_.setUserSelectTableSchemas(bl);
        }
        this.changeListeners_.firePropertyChange("userSelectTableSchemas", new Boolean(bl2), new Boolean(bl));
    }

    private void setupPane() {
        this.fields_ = new SQLMetaDataTableModel(this.connection_, this.tables_);
        this.fields_.addErrorListener(this.panelErrors_);
        this.setLayout(new BorderLayout());
        this.notebook_ = new JTabbedPane();
        this.tablePane_ = new SQLQueryTablePane(this, this.connection_, this.tables_, this.schemas_, this.schemasUserDefined_);
        this.tablePane_.addErrorListener(this.panelErrors_);
        this.notebook_.addTab(ResourceLoader.getQueryText("DBQUERY_LABEL_TABLES"), null, this.tablePane_);
        this.selectPane_ = new SQLQuerySelectPane(this);
        this.notebook_.addTab("Select", null, this.selectPane_);
        this.joinPane_ = new SQLQueryJoinPane(this);
        this.notebook_.addTab("Join By", null, this.joinPane_);
        this.wherePane_ = new SQLQueryWherePane(this);
        this.notebook_.addTab("Where", null, this.wherePane_);
        this.groupPane_ = new SQLQueryGroupPane(this);
        this.notebook_.addTab("Group By", null, this.groupPane_);
        this.havingPane_ = new SQLQueryHavingPane(this);
        this.notebook_.addTab("Having", null, this.havingPane_);
        this.orderPane_ = new SQLQueryOrderPane(this);
        this.notebook_.addTab("Order By", null, this.orderPane_);
        this.summaryPane_ = new SQLQuerySummaryPane(this);
        this.notebook_.addTab(ResourceLoader.getQueryText("DBQUERY_LABEL_SUMMARY"), null, this.summaryPane_);
        this.notebook_.setSelectedIndex(0);
        this.tablePane_.init();
        this.tablePane_.setEnabled(this.tablesUserDefined_);
        if (this.tables_.length == 1) {
            this.notebook_.setEnabledAt(2, false);
        } else if (this.tables_.length == 0) {
            this.notebook_.setEnabledAt(1, false);
            this.notebook_.setEnabledAt(2, false);
            this.notebook_.setEnabledAt(3, false);
            this.notebook_.setEnabledAt(4, false);
            this.notebook_.setEnabledAt(5, false);
            this.notebook_.setEnabledAt(6, false);
        }
        this.notebook_.addChangeListener(new Listener_());
        this.add("Center", this.notebook_);
    }

    synchronized void updatePage() {
        Trace.log(1, "Updating page " + this.currentPane_);
        switch (this.currentPane_) {
            case 0: {
                this.tablePane_.update();
                break;
            }
            case 1: {
                if (!this.panelInit[1]) {
                    this.selectPane_.init();
                    this.panelInit[1] = true;
                    this.selectPane_.validate();
                    break;
                }
                this.selectPane_.update();
                break;
            }
            case 2: {
                if (!this.panelInit[2]) {
                    this.joinPane_.init();
                    this.panelInit[2] = true;
                    this.joinPane_.validate();
                    break;
                }
                this.joinPane_.update();
                break;
            }
            case 3: {
                if (!this.panelInit[3]) {
                    this.wherePane_.init();
                    this.panelInit[3] = true;
                    this.wherePane_.validate();
                    break;
                }
                this.wherePane_.update();
                break;
            }
            case 4: {
                if (!this.panelInit[4]) {
                    this.groupPane_.init();
                    this.panelInit[4] = true;
                    this.groupPane_.validate();
                    break;
                }
                this.groupPane_.update();
                break;
            }
            case 5: {
                if (!this.panelInit[5]) {
                    this.havingPane_.init();
                    this.panelInit[5] = true;
                    this.havingPane_.validate();
                    break;
                }
                this.havingPane_.update();
                break;
            }
            case 6: {
                if (!this.panelInit[6]) {
                    this.orderPane_.init();
                    this.panelInit[6] = true;
                    this.orderPane_.validate();
                    break;
                }
                this.orderPane_.update();
                break;
            }
            case 7: {
                if (!this.panelInit[7]) {
                    this.summaryPane_.init();
                    this.panelInit[7] = true;
                    this.summaryPane_.validate();
                    break;
                }
                this.summaryPane_.update();
                break;
            }
            default: {
                Trace.log(2, "Unknown page " + this.currentPane_);
            }
        }
    }

    private class Listener_
    implements ChangeListener {
        private Listener_() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SQLQueryBuilderPane.this.worker_.startWorking(SQLQueryBuilderPane.this.workEvent_);
            SQLQueryBuilderPane.this.completePage();
            SQLQueryBuilderPane.this.currentPane_ = SQLQueryBuilderPane.this.notebook_.getSelectedIndex();
            SQLQueryBuilderPane.this.updatePage();
            SQLQueryBuilderPane.this.worker_.stopWorking(SQLQueryBuilderPane.this.workEvent_);
        }
    }
}

